-- ============================================
-- Binary Trades Table Structure
-- ============================================
-- This SQL file contains the table structure for binary trades functionality
-- Import this file into your database to create the binary_trades table
-- ============================================

-- Table structure for table `binary_trades`
CREATE TABLE IF NOT EXISTS `binary_trades` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `coin_pair_id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `amount` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `last_price` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `result_price` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `win_amount` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `profit` decimal(8,2) NOT NULL DEFAULT 0.00,
  `duration` int(11) NOT NULL DEFAULT 0,
  `trade_ended_at` datetime DEFAULT NULL,
  `direction` varchar(40) DEFAULT NULL,
  `result` varchar(40) DEFAULT NULL,
  `trx` varchar(40) DEFAULT NULL,
  `win_status` tinyint(1) NOT NULL DEFAULT 0,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `coin_pair_id` (`coin_pair_id`),
  KEY `win_status` (`win_status`),
  KEY `status` (`status`),
  KEY `trx` (`trx`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Table Column Descriptions:
-- ============================================
-- id: Primary key, auto-increment
-- user_id: Foreign key to users table
-- coin_pair_id: Foreign key to coin_pairs table
-- amount: Trade amount in decimal(28,8)
-- last_price: Price at trade start
-- result_price: Price at trade end
-- win_amount: Amount won (if trade is won)
-- profit: Profit percentage
-- duration: Trade duration in seconds
-- trade_ended_at: Timestamp when trade ends
-- direction: Trade direction (higher/lower)
-- result: Trade result
-- trx: Transaction reference
-- win_status: 0=Pending, 1=Win, 2=Lose, 3=Refund, 4=Processing
-- status: 0=Running, 1=Closed
-- created_at: Record creation timestamp
-- updated_at: Record update timestamp
-- ============================================

