(function ($) {
  $.fn.customSelect = function (options) {
    return this.each(function (index, elementData) {
      var settings = $.extend(
        {
          search: false,
        },
        options
      );

      let element = $(elementData);
      let time = Date.now() + "" + Math.floor(Math.random() * 10000);
      let parentClassName = `custom-select-parent-${time}`;
      element.parent("div").addClass(parentClassName);

      let defaultValue = defaultTitle(element);

      let defaultImage = defaultThumb(element);

      let selectOptions = element.find("option");
      let selectHtml = `<div class="custom-select-area">
                <div class="selected-option d-flex justify-content-between align-items-center">
                    <div class="d-flex align-items-center">
                        <div class="option-thumb ${
                          !defaultImage ? "d-none" : "d-block"
                        } option-thumb-${time}" style="background-image:url(${defaultImage})"></div>
                        <p class="custom-select-title select-title-${time}">${defaultValue}</p>
                    </div>
                    <div class="icon-area">
                        <i class="las la-angle-down"></i>
                    </div>
                </div>
                <div class="custom-select-list d-none">`;

      $.each(selectOptions, function (key, option) {
        option = $(option);
        if (option.data("title") || option.text()) {
          selectHtml += `<div class="single-select-option" data-value="${option.val()}">`;
          if (option.data("image")) {
            selectHtml += `<div class="option-thumb" data-thumb="${option.data(
              "image"
            )}" style="background-image:url(${option.data("image")})"></div>`;
          }

          selectHtml += `<div class="custom-select-title-area">
                            <p class="custom-select-title">${
                              option.data("title")
                                ? option.data("title")
                                : option.text()
                            }</p>`;
          if (option.data("subtitle")) {
            selectHtml += `<p class="custom-select-sub-title">${option.data(
              "subtitle"
            )}</p>`;
          }
          selectHtml += `</div></div>`;
        }
      });
      selectHtml += `</div></div>`;
      element.after(selectHtml);

      $(`.${parentClassName}`)
        .find(".selected-option")
        .on("click", function () {
          if (settings.search) {
            $(`.${parentClassName} .single-select-option`).removeClass(
              "d-none"
            );
            if ($(this).hasClass("search-enabled")) {
              return;
            }
          }

          $(`.${parentClassName}`)
            .find(".custom-select-area")
            .toggleClass("focus");

          $(`.${parentClassName}`)
            .find(".custom-select-list")
            .toggleClass("d-none");
          $(this).find(".icon-area").find("i").toggleClass("la-angle-up");
          $(this).find(".icon-area").find("i").toggleClass("la-angle-down");
          if (settings.search) {
            $(this).addClass("search-enabled");
            $(this).html(
              '<input type="text" class="custom-select-filter" placeholder="Search here...">'
            );
            $(this).find(".custom-select-filter").focus();
          }
        });

      if (settings.search) {
        $(document).on(
          "input",
          `.${parentClassName} .custom-select-filter`,
          function () {
            let search = $(this).val().toLowerCase();

            let match = $(`.${parentClassName} .single-select-option`).filter(
              function (idx, elem) {
                return $(elem)
                  .find(".custom-select-title")
                  .text()
                  .trim()
                  .toLowerCase()
                  .indexOf(search) >= 0
                  ? true
                  : false;
              }
            );
            $(`.${parentClassName} .single-select-option`).addClass("d-none");
            match.each(function (idx, elem) {
              $(elem).removeClass("d-none");
            });
          }
        );
      }

      $(document).on(
        "click",
        `.${parentClassName} .single-select-option`,
        function (e) {
          if (settings.search) {
            $(`.${parentClassName}`)
              .find(".selected-option")
              .removeClass("search-enabled");
            $(`.${parentClassName}`)
              .find(".selected-option")
              .html(
                `<div class="d-flex align-items-center">
                            <div class="option-thumb option-thumb-${time}"></div>
                            <p class="custom-select-title select-title-${time}"></p>
                        </div>
                        <div class="icon-area">
                            <i class="las la-angle-down"></i>
                        </div>`
              );
          }
          $(`.${parentClassName} .selected-option .custom-select-title`).text(
            $(this).find(".custom-select-title").text()
          );
          let thumb = $(this).find(".option-thumb").data("thumb");
          if (thumb) {
            $(`.${parentClassName} .selected-option .option-thumb`).removeClass(
              "d-none"
            );
            $(`.${parentClassName} .selected-option .option-thumb`).addClass(
              "d-block"
            );
            $(`.${parentClassName} .selected-option .option-thumb`).css(
              "background-image",
              `url(${$(this).find(".option-thumb").data("thumb")})`
            );
          } else {
            $(`.${parentClassName} .selected-option .option-thumb`).addClass(
              "d-none"
            );
            $(`.${parentClassName} .selected-option .option-thumb`).removeClass(
              "d-block"
            );
            $(`.${parentClassName} .selected-option .option-thumb`).css(
              "background-image",
              ""
            );
          }
          $(`.${parentClassName}`)
            .find(".custom-select-area")
            .removeClass("focus");
          element.val($(this).data("value"));
          element.trigger("change");
        }
      );

      $("body").on("click", function (e) {
        let targetElement = $(`.${parentClassName} .selected-option`)[0];
        if (
          ($(e.target).hasClass(`select-title-${time}`) ||
            $(e.target).hasClass(`option-thumb-${time}`)) &&
          !$(e.target).closest(".custom-select-list").length
        ) {
          return;
        }
        if (!targetElement.contains(e.target)) {
          if (
            !$(`.${parentClassName} .custom-select-list`).hasClass("d-none")
          ) {
            $(`.${parentClassName}`)
              .find(".custom-select-area")
              .removeClass("focus");
            if (settings.search) {
              $(`.${parentClassName}`)
                .find(".selected-option")
                .removeClass("search-enabled");
              $(`.${parentClassName}`)
                .find(".selected-option")
                .html(
                  `<div class="d-flex align-items-center">
                                    <div class="option-thumb option-thumb-${time} ${
                    !defaultThumb(element) ? "d-none" : "d-block"
                  }" style="background-image:url(${defaultThumb(
                    element
                  )})"></div>
                                    <p class="custom-select-title select-title-${time}">${defaultTitle(
                    element
                  )}</p>
                                </div>
                                <div class="icon-area">
                                    <i class="las la-angle-up"></i>
                                </div>`
                );
            }

            $(`.${parentClassName} .custom-select-list`).addClass("d-none");
            $(`.${parentClassName} .selected-option .icon-area i`).toggleClass(
              "la-angle-up"
            );
            $(`.${parentClassName} .selected-option .icon-area i`).toggleClass(
              "la-angle-down"
            );
          }
        }
      });
    });

    return this;
  };

  function defaultTitle(element) {
    let defaultValue = element.find(`:selected`).data("title");
    if (!defaultValue) {
      defaultValue = element.find(`:selected`).text();
    }
    if (!defaultValue) {
      defaultValue = element.find(`:first-child`).data("title");
    }
    if (!defaultValue) {
      defaultValue = element.find(`:first-child`).text();
    }
    return defaultValue;
  }

  function defaultThumb(element) {
    let defaultImage = element.find(`:selected`).data("image");
    if (!defaultImage) {
      defaultImage = element.find(`:first-child`).data("image");
    }
    return defaultImage;
  }
})(jQuery);
