<?php

namespace App\Lib;

class GetCommodity
{

    public static function getApiCommodities()
    {
        try {
            $apiKey = gs('rapid_api_key');

            if (empty($apiKey)) {
                return [
                    'success' => false,
                    'message' => 'RapidAPI key is not configured. Please add your API key in the settings.'
                ];
            }

            $url = "https://commodity-prices2.p.rapidapi.com/api/Commodity";
            $headers = [
                "x-rapidapi-host: commodity-prices2.p.rapidapi.com",
                "x-rapidapi-key: " . $apiKey
            ];

            $response = CurlRequest::curlContent($url, $headers);

            if (!$response) {
                return [
                    'success' => false,
                    'message' => 'Failed to receive a response from the commodity API'
                ];
            }

            $decodedResponse = json_decode($response, true);

            if (json_last_error() !== JSON_ERROR_NONE) {
                return [
                    'success' => false,
                    'message' => 'Invalid response from commodity API'
                ];
            }

            if (isset($decodedResponse['message'])) {
                return [
                    'success' => false,
                    'message' => $decodedResponse['message']
                ];
            }

            if (!is_array($decodedResponse) || empty($decodedResponse)) {
                return [
                    'success' => false,
                    'message' => 'No commodity data received from API.'
                ];
            }

            if (!isset($decodedResponse[0]['name']) || !isset($decodedResponse[0]['unit']) || !isset($decodedResponse[0]['price'])) {
                return [
                    'success' => false,
                    'message' => 'Invalid commodity data structure received from API'
                ];
            }

            return [
                'success' => true,
                'data' => $decodedResponse
            ];
        } catch (\Exception $e) {
            return [
                'success' => false,
                'message' => 'An error occurred while fetching commodity data: ' . $e->getMessage()
            ];
        }
    }

}
