<?php

namespace App\Models;

use App\Constants\Status;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Asset extends Model
{
    use HasFactory;

    public function commodity()
    {
        return $this->belongsTo(Commodity::class, 'commodity_id');
    }

    public function  scopeTotalAssetBalance($query)
    {
        $query->join('commodities', function ($join) {
            $join->on('assets.commodity_id', '=', 'commodities.id')
                ->where('commodities.status', Status::ENABLE);
        })->selectRaw('sum(assets.quantity * commodities.price) as total_asset_balance');
    }

    public function getAssetBalance($userId)
    {
        return $this->where('user_id', $userId)
            ->join('commodities', function ($join) {
                $join->on('assets.commodity_id', '=', 'commodities.id')
                    ->where('commodities.status', '1');
            })
            ->selectRaw('sum(assets.quantity * commodities.price) as total_asset_balance')
            ->value('total_asset_balance');
    }
}
