<?php

namespace App\Models;

use App\Traits\GlobalStatus;
use Illuminate\Database\Eloquent\Model;

class Commodity extends Model
{
    use GlobalStatus;

    public function scopeHasPrice($query)
    {
        return $query->where('price', '!=', 0);
    }

    public function priceSnapshot()
    {
        return $this->hasOne(CommodityPriceSnapshot::class);
    }

}
