@extends('admin.layouts.app')

@section('panel')
    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <form action="{{ route('admin.commodity.save',@$commodity->id) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-3">
                                <div class="form-group">
                                    <label class="required">@lang('Image')</label>
                                    <x-image-uploader image="{{ @$commodity->image }}" class="w-100" type="commodityImage" :required=false />
                                </div>
                            </div>
                            <div class="col-lg-9">
                                <div class="row">
                                    <div class="form-group col-md-12">
                                        <label>@lang('Name')</label>
                                        <input type="text" class="form-control" name="name" required value="{{ old('name',@$commodity->name) }}" />
                                    </div>
                                    <div class="form-group col-md-12">
                                        <label>@lang('Unit')</label>
                                        <input type="text" class="form-control" name="unit" required value="{{ old('unit',@$commodity->unit) }}" />
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label>@lang('Price')</label>
                                        <div class="input-group">
                                            <input type="number" step="any" class="form-control" name="price" value="{{ old('price',getAmount(@$commodity->price)) }}"
                                                required />
                                            <div class="input-group-text"> {{ __(gs()->cur_text) }} </div>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label>@lang('Market Capital')</label>
                                        <div class="input-group">
                                            <input type="number" step="any" class="form-control" name="market_capital"
                                                value="{{ old('market_capital',getAmount(@$commodity->market_capital)) }}" required />
                                            <div class="input-group-text"> {{ __(gs()->cur_text) }} </div>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label>@lang('24h Change')</label>
                                        <div class="input-group">
                                            <input type="number" step="any" class="form-control" name="twenty_four_hour_change"
                                                value="{{ old('twenty_four_hour_change',@$commodity->twenty_four_hour_change) }}" required>
                                            <div class="input-group-text">%</div>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label>@lang('7 Day Change')</label>
                                        <div class="input-group">
                                            <input type="number" step="any" class="form-control" name="seven_day_change"
                                                value="{{ old('seven_day_change',@$commodity->seven_day_change) }}" required>
                                            <div class="input-group-text">%</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('breadcrumb-plugins')
    <x-back route="{{ route('admin.commodity.index') }}" />
@endpush
