@extends('admin.layouts.app')

@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10">
                <div class="card-body p-0">
                    <div class="table-responsive--md table-responsive">
                        <form action="{{ route('admin.commodity.storeFetched') }}" method="POST">
                            @csrf
                            <div class="card-header">
                                <div class="d-flex justify-content-between align-items-center">
                                    <span class="text--muted">
                                        @lang('Selected'): <span id="selectedCount"
                                            class="fw-bold text--primary">0</span> / {{ count($newCommodities) }}
                                    </span>
                                    <div class="text-end">
                                        @if (count($newCommodities) > 0)
                                            <button type="button" class="btn btn-sm btn-outline--primary selectAllBtn"
                                                id="selectAll">
                                                @lang('Select All')
                                            </button>
                                            <button type="button" class="btn btn-sm btn-outline--secondary deSelectAllBtn"
                                                id="deselectAll">
                                                @lang('Deselect All')
                                            </button>
                                        @endif
                                        <x-back route="{{ route('admin.commodity.index') }}" />
                                    </div>
                                </div>
                            </div>

                            @if (count($newCommodities) > 0)
                                {{-- <!-- Selected Count Display -->
                                <div class="card-header border-top">
                                    <div class="d-flex justify-content-between align-items-center">

                                    </div>
                                </div> --}}

                                <table class="table table--light style--two">
                                    <thead>
                                        <tr>
                                            <th>
                                                <input type="checkbox" id="checkAll" class="form-check-input">
                                            </th>
                                            <th>@lang('Name')</th>
                                            <th>@lang('Unit')</th>
                                            <th>@lang('Current Price')</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($newCommodities as $key => $commodity)
                                            <tr>
                                                <td>
                                                    <input type="checkbox" id="commodity-{{ $key }}"
                                                        name="commodities[]" value="{{ $commodity['name'] }}"
                                                        class="form-check-input commodity-checkbox">
                                                </td>
                                                <td>
                                                    <label for="commodity-{{ $key }}" class="fw-bold">
                                                        {{ $commodity['name'] }}
                                                    </label>
                                                </td>
                                                <td>
                                                    <span class="text-muted">{{ $commodity['unit'] }}</span>
                                                </td>
                                                <td>
                                                    <span
                                                        class="text--primary fw-bold">{{ showAmount($commodity['price']) }}</span>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>

                                <!-- Store Button at Bottom -->
                                <div class="card-footer text-center">
                                    <button type="submit" class="btn btn--primary w-100 h-45" id="storeButton" disabled>
                                        <i class="las la-save"></i> @lang('Store Selected') (<span class="text-white"
                                            id="storeButtonCount">0</span>)
                                    </button>
                                </div>
                            @else
                                <div class="text-center p-4">
                                    <div class="text-center">
                                        <i class="las la-frown text-muted"></i>
                                        <h4 class="text-muted mt-2">@lang('No New Commodities Found')</h4>
                                        <p class="text-muted">@lang('All commodities from the API are already in your database.')</p>
                                    </div>
                                </div>
                            @endif
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('style')
    <style>
        @media (max-width: 457px) {

            .deSelectAllBtn,
            .selectAllBtn {
                margin-bottom: 5px;
            }
        }
    </style>
@endpush
@push('script')
    <script>
        'use strict';

        function updateSelectedCount() {
            var checkedCount = $('.commodity-checkbox:checked').length;
            $('#selectedCount').text(checkedCount);
            $('#storeButtonCount').text(checkedCount);

            if (checkedCount > 0) {
                $('#storeButton').prop('disabled', false);
            } else {
                $('#storeButton').prop('disabled', true);
            }
        }

        $('#checkAll').on('change', function() {
            $('.commodity-checkbox').prop('checked', this.checked);
            updateSelectedCount();
        });

        $('.commodity-checkbox').on('change', function() {
            var totalCheckboxes = $('.commodity-checkbox').length;
            var checkedCheckboxes = $('.commodity-checkbox:checked').length;

            $('#checkAll').prop('checked', totalCheckboxes === checkedCheckboxes);
            updateSelectedCount();
        });

        $('#selectAll').on('click', function() {
            $('.commodity-checkbox').prop('checked', true);
            $('#checkAll').prop('checked', true);
            updateSelectedCount();
        });

        $('#deselectAll').on('click', function() {
            $('.commodity-checkbox').prop('checked', false);
            $('#checkAll').prop('checked', false);
            updateSelectedCount();
        });

        $('form').on('submit', function(e) {
            var checkedBoxes = $('.commodity-checkbox:checked').length;
            if (checkedBoxes === 0) {
                e.preventDefault();
                alert('Please select at least one commodity to store.');
                return false;
            }
        });

        $(document).ready(function() {
            updateSelectedCount();
        });
    </script>
@endpush
