@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('Name')</th>
                                    <th>@lang('Unit')</th>
                                    <th>@lang('Price')</th>
                                    <th>@lang('24h Change')</th>
                                    <th>@lang('7 Day Change')</th>
                                    <th>@lang('Market Capital')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($commodities as $commodity)
                                    <tr>
                                        <td>
                                            <div class="user">
                                                <div class="thumb">
                                                    <img src="{{ getImage(getFilePath('commodityImage') . '/' . $commodity->image, getFileSize('commodityImage')) }}"
                                                        class="plugin_bg">
                                                </div>
                                                <span class="name">{{ __($commodity->name) }}</span>
                                            </div>
                                        </td>
                                        <td>{{ __($commodity->unit) }}</td>
                                        <td>{{ showAmount($commodity->price) }}</td>
                                        <td>
                                            <span
                                                class="{{ $commodity->twenty_four_hour_change < 0 ? 'text--danger' : ($commodity->twenty_four_hour_change > 0 ? 'text--success' : 'black') }}">
                                                {{ $commodity->twenty_four_hour_change }}%
                                            </span>
                                        </td>
                                        <td>
                                            <span
                                                class="{{ $commodity->seven_day_change < 0 ? 'text--danger' : ($commodity->seven_day_change > 0 ? 'text--success' : 'black') }}">
                                                {{ $commodity->seven_day_change }}%
                                        </td>
                                        </span>

                                        <td>{{ showAmount($commodity->market_capital) }}</td>
                                        <td>@php echo $commodity->statusBadge; @endphp </td>
                                        <td>
                                            <div class="button--group">
                                                <a href="{{ route('admin.commodity.edit', $commodity->id) }}"
                                                    class="btn btn-sm btn-outline--primary ms-1"><i class="las la-pen"></i> @lang('Edit')</a>

                                                @if ($commodity->status == Status::ENABLE)
                                                    <button class="btn btn-sm btn-outline--danger ms-1 confirmationBtn" data-question="@lang('Are you sure to disable this commodity?')"
                                                        data-action="{{ route('admin.commodity.status', $commodity->id) }}">
                                                        <i class="la la-eye-slash"></i> @lang('Disable')
                                                    </button>
                                                @else
                                                    <button class="btn btn-sm btn-outline--success ms-1 confirmationBtn"
                                                        data-question="@lang('Are you sure to enable this commodity?')"
                                                        data-action="{{ route('admin.commodity.status', $commodity->id) }}">
                                                        <i class="la la-eye"></i> @lang('Enable')
                                                    </button>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse

                            </tbody>
                        </table>
                    </div>
                </div>
                @if ($commodities->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($commodities) }}
                    </div>
                @endif
            </div>
        </div>
    </div>

    <x-confirmation-modal />
@endsection

@push('breadcrumb-plugins')
    <x-search-form />
    <a href="{{ route('admin.commodity.add') }}" class="btn btn-sm btn-outline--primary"><i class="las la-plus"></i>@lang('Add New')</a>
    <a href="{{ route('admin.commodity.fetch') }}" class="btn btn-sm btn-outline--primary"><i class="las la-sync"></i>@lang('Fetch from API')</a>
@endpush
