@extends('admin.layouts.app')
@section('panel')
    <div class="row mb-none-30">
        <div class="col-lg-12 col-md-12 mb-30">
            <div class="card">
                <div class="card-body">
                    <form method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-xl-4 col-sm-6">
                                <div class="form-group ">
                                    <label> @lang('Site Title')</label>
                                    <input class="form-control" type="text" name="site_name" required
                                        value="{{ gs('site_name') }}">
                                </div>
                            </div>
                            <div class="col-xl-4 col-sm-6">
                                <div class="form-group ">
                                    <label>@lang('Currency')</label>
                                    <input class="form-control" type="text" name="cur_text" required
                                        value="{{ gs('cur_text') }}">
                                </div>
                            </div>
                            <div class="col-xl-4 col-sm-6">
                                <div class="form-group ">
                                    <label>@lang('Currency Symbol')</label>
                                    <input class="form-control" type="text" name="cur_sym" required
                                        value="{{ gs('cur_sym') }}">
                                </div>
                            </div>
                            <div class="form-group col-xl-4 col-sm-6">
                                <label> @lang('Timezone')</label>
                                <select class="select2 form-control" name="timezone">
                                    @foreach ($timezones as $key => $timezone)
                                        <option value="{{ @$key }}" @selected(@$key == $currentTimezone)>{{ __($timezone) }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group col-xl-4 col-sm-6">
                                <label> @lang('Site Base Color')</label>
                                <div class="input-group">
                                    <span class="input-group-text p-0 border-0">
                                        <input type='text' class="form-control colorPicker"
                                            value="{{ gs('base_color') }}">
                                    </span>
                                    <input type="text" class="form-control colorCode" name="base_color"
                                        value="{{ gs('base_color') }}">
                                </div>
                            </div>
                            <div class="form-group col-xl-4 col-sm-6">
                                <label> @lang('Site Secondary Color')</label>
                                <div class="input-group">
                                    <span class="input-group-text p-0 border-0">
                                        <input type='text' class="form-control colorPicker"
                                            value="{{ gs('secondary_color') }}">
                                    </span>
                                    <input type="text" class="form-control colorCode" name="secondary_color"
                                        value="{{ gs('secondary_color') }}">
                                </div>
                            </div>
                            <div class="form-group col-xl-4 col-sm-6">
                                <label> @lang('Record to Display Per page')</label>
                                <select class="select2 form-control" name="paginate_number"
                                    data-minimum-results-for-search="-1">
                                    <option value="20" @selected(gs('paginate_number') == 20)>@lang('20 items per page')</option>
                                    <option value="50" @selected(gs('paginate_number') == 50)>@lang('50 items per page')</option>
                                    <option value="100" @selected(gs('paginate_number') == 100)>@lang('100 items per page')</option>
                                </select>
                            </div>

                            <div class="form-group col-xl-4 col-sm-6 ">
                                <label> @lang('Currency Showing Format')</label>
                                <select class="select2 form-control" name="currency_format"
                                    data-minimum-results-for-search="-1">
                                    <option value="1" @selected(gs('currency_format') == Status::CUR_BOTH)>@lang('Show Currency Text and Symbol Both')</option>
                                    <option value="2" @selected(gs('currency_format') == Status::CUR_TEXT)>@lang('Show Currency Text Only')</option>
                                    <option value="3" @selected(gs('currency_format') == Status::CUR_SYM)>@lang('Show Currency Symbol Only')</option>
                                </select>
                            </div>
                            <div class="col-xl-4 col-sm-6">
                                <div class="form-group ">
                                    <label>@lang('API Key')</label>
                                    <i class="las la-info-circle text--primary ms-2"
                                        style="cursor: pointer; font-size: 18px;" data-bs-toggle="modal"
                                        data-bs-target="#apiKeyInstructionsModal" title="How to get API Key"></i>
                                    <input class="form-control" type="text" name="rapid_api_key" required
                                        value="{{ gs('rapid_api_key') }}">
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn--primary w-100 h-45">@lang('Submit')</button>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="apiKeyInstructionsModal" tabindex="-1" aria-labelledby="apiKeyInstructionsModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header bg--primary">
                    <h5 class="modal-title text-white" id="apiKeyInstructionsModalLabel">
                        <i class="las la-key"></i> @lang('How to Get RapidAPI Key')
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-info">
                                <i class="las la-info-circle"></i>
                                @lang('Follow these simple steps to get your RapidAPI key for commodity price data.')
                            </div>

                            <div class="card border--primary mb-3">
                                <div class="card-header bg-light">
                                    <h6 class="mb-0">
                                        <span class="badge bg--primary me-2">1</span>
                                        @lang('Create RapidAPI Account')
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <p class="mb-2">@lang('Go to RapidAPI and create a free account:')</p>
                                    <a href="https://rapidapi.com/auth/sign-up" target="_blank"
                                        class="btn btn-sm btn-outline--primary">
                                        <i class="las la-external-link-alt"></i> @lang('Sign Up on RapidAPI')
                                    </a>
                                </div>
                            </div>

                            <div class="card border-success mb-3">
                                <div class="card-header bg-light">
                                    <h6 class="mb-0">
                                        <span class="badge bg--success me-2">@lang('2')</span>
                                        @lang('Choose a Plan')
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <p class="mb-2">@lang('Subscribe to the Commodity Prices API. Basic free plan includes 10 requests per month:')</p>
                                    <div class="alert alert-success py-2">
                                        <small>
                                            <i class="las la-check-circle"></i>
                                            <strong>@lang('Free Plan:')</strong> @lang('10 requests/month - Perfect for testing')
                                        </small>
                                    </div>
                                    <a href="https://rapidapi.com/rickavila1/api/commodity-prices2/pricing"
                                        target="_blank" class="btn btn-sm btn-outline--success">
                                        <i class="las la-external-link-alt"></i> @lang('View Pricing Plans')
                                    </a>
                                </div>
                            </div>

                            <div class="card border-warning mb-3">
                                <div class="card-header bg-light">
                                    <h6 class="mb-0">
                                        <span class="badge bg--warning me-2">3</span>
                                        @lang('Get Your API Key')
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <p class="mb-2">@lang('After subscribing, get your API key from the playground section:')</p>
                                    <div class="alert alert-warning py-2">
                                        <small>
                                            <i class="las la-key"></i>
                                            @lang('Your API key will be shown in the "X-RapidAPI-Key" header')
                                        </small>
                                    </div>
                                    <a href="https://rapidapi.com/rickavila1/api/commodity-prices2/playground/apiendpoint_d0dbbeb1-bc37-4f38-ba37-040ecc4e7a64"
                                        target="_blank" class="btn btn-sm btn-outline--warning">
                                        <i class="las la-external-link-alt"></i> @lang('Get API Key')
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn--dark" data-bs-dismiss="modal">
                        <i class="las la-times"></i> @lang('Close')
                    </button>
                    <a href="https://rapidapi.com/rickavila1/api/commodity-prices2" target="_blank"
                        class="btn btn--primary">
                        <i class="las la-external-link-alt"></i> @lang('Go to API Page')
                    </a>
                </div>
            </div>
        </div>
    </div>
@endsection


@push('script-lib')
    <script src="{{ asset('assets/admin/js/spectrum.js') }}"></script>
@endpush

@push('style-lib')
    <link rel="stylesheet" href="{{ asset('assets/admin/css/spectrum.css') }}">
@endpush

@push('style')
    <style>

        .card {
            transition: all 0.3s ease;
        }

        .card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }

        .badge {
            font-size: 12px;
            padding: 6px 10px;
        }

        .alert {
            border-radius: 8px;
            padding: 10px;
        }

        .btn {
            border-radius: 6px;
        }
    </style>
@endpush
@push('script')
    <script>
        (function($) {
            "use strict";


            $('.colorPicker').spectrum({
                color: $(this).data('color'),
                change: function(color) {
                    $(this).parent().siblings('.colorCode').val(color.toHexString().replace(/^#?/, ''));
                }
            });

            $('.colorCode').on('input', function() {
                var clr = $(this).val();
                $(this).parents('.input-group').find('.colorPicker').spectrum({
                    color: clr,
                });
            });
        })(jQuery);
    </script>
@endpush
