@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th> @lang('Commodity') </th>
                                    <th> @lang('User') </th>
                                    <th> @lang('Type') </th>
                                    <th> @lang('Quantity')</th>
                                    <th> @lang('Unit Price')</th>
                                    <th> @lang('Total Price')</th>
                                    <th>@lang('Date')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($trades as $trade)
                                    <tr>
                                        <td>
                                            <div class="user">
                                                <div class="thumb">
                                                    <img src="{{ getImage(getFilePath('commodityImage') . '/' . @$trade->commodity->image, getFileSize('commodityImage')) }}"
                                                        class="plugin_bg">
                                                </div>
                                                <span class="name">{{ __(@$trade->commodity->name) }}</span>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="fw-bold">{{ $trade->user->fullname }}</span>
                                            <br>
                                            <span class="small">
                                                <a
                                                    href="{{ route('admin.users.detail', $trade->user_id) }}"><span>@</span>{{ @$trade->user->username }}</a>
                                            </span>
                                        </td>
                                        <td>
                                            @if ($trade->type == Status::TRADE_TYPE_BUY)
                                                <span class="text--success">@lang('Buy')</span>
                                            @else
                                                <span class="text--danger">@lang('Sell')</span>
                                            @endif
                                        </td>
                                        <td>
                                            {{ showAmount($trade->quantity, 8, currencyFormat:false) }} {{ __($trade->commodity->unit) }}
                                        </td>
                                        <td>
                                            <div>{{ showAmount($trade->price) }}/{{ __($trade->commodity->unit) }}</div>
                                        </td>
                                        <td>{{ showAmount($trade->total_cost) }}</td>
                                        <td>
                                            <div>
                                                {{ showDateTime($trade->created_at) }} <br>
                                                {{ diffForHumans($trade->created_at) }}
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse

                            </tbody>
                        </table>
                    </div>
                </div>
                @if ($trades->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($trades) }}
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection

@push('breadcrumb-plugins')
    <x-search-form />
@endpush
