@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <section class="blog-detials py-110">
        <div class="container">
            <div class="row gy-4 justify-content-center ">
                <div class="col-xl-9 col-lg-8">
                    <div class="blog-details">
                        <div class="blog-details__thumb">
                            <img src="{{ frontendImage('blog', $blog->data_values->blog_image, '900x630') }}" class="w-100"
                                alt="@lang('Blog Image')">
                        </div>
                        <div class="blog-details__content">
                            <span class="blog-item__time mb-2">
                                <span class="blog-item__date-icon"><i class="las la-clock"></i></span>
                                {{ showDateTime($blog->created_at, 'j F, Y') }}
                            </span>
                            <h3 class="blog-details__title"> {{ __(@$blog->data_values->title) }} </h3>
                            <div class="blog-details__desc">@php echo $blog->data_values->description @endphp</div>
                            <div class="blog-details__share">
                                <h5 class="blog-details__share-title">@lang('Share This'): </h5>
                                <ul class="social-list">
                                    <li class="social-list__item">
                                        <a href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode(url()->current()) }}"
                                            target="_blank" class="social-list__link flex-center"><i
                                                class="fab fa-facebook-f"></i></a>
                                    </li>
                                    <li class="social-list__item">
                                        <a href="https://twitter.com/intent/tweet?text={{ __(@$blog->data_values->title) }}&amp;url={{ urlencode(url()->current()) }}"
                                            target="_blank" class="social-list__link flex-center"><i
                                                class="fab fa-twitter"></i></a>
                                    </li>
                                    <li class="social-list__item">
                                        <a href="https://pinterest.com/pin/create/bookmarklet/?media={{ frontendImage('blog', @$blog->data_values->blog_image, '1020x820') }}&url={{ urlencode(url()->current()) }}"
                                            target="_blank" class="social-list__link flex-center"><i
                                                class="fab fa-pinterest-p"></i>
                                        </a>
                                    </li>
                                    <li class="social-list__item">
                                        <a href="http://www.linkedin.com/shareArticle?mini=true&amp;url={{ urlencode(url()->current()) }}"
                                            target="_blank" class="social-list__link flex-center"><i
                                                class="fab fa-linkedin-in"></i></a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="fb-comments" data-href="{{ url()->current() }}" data-numposts="5"></div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-4">
                    <div class="blog-sidebar-wrapper">
                        <div class="blog-sidebar">
                            <h5 class="blog-sidebar__title"> @lang('Latest Blog') </h5>
                            @foreach ($blogs as $latestBlog)
                                <div class="latest-blog">
                                    <div class="latest-blog__thumb">
                                        <a href="{{ route('blog.details', $latestBlog->slug) }}">
                                            <img src="{{ frontendImage('blog', $latestBlog->data_values->blog_image, '400x280', thumb: true) }}"
                                                alt="@lang('Blog Image')">
                                        </a>
                                    </div>
                                    <div class="latest-blog__content">
                                        <h6 class="latest-blog__title">
                                            <a
                                                href="{{ route('blog.details', $latestBlog->slug) }}">{{ @__($latestBlog->data_values->title) }}</a>
                                        </h6>
                                        <span
                                            class="latest-blog__date">{{ showDateTime($latestBlog->created_at, 'j F, Y') }}</span>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('fbComment')
    @php echo loadExtension('fb-comment') @endphp
@endpush

@push('style')
    <style>
        .blog-details__desc h4 {
            color: hsl(var(--heading-color)/0.7);
            margin-bottom: 0.5rem;
            font-size: 20px;
        }

        .blog-details__desc p {
            color: hsl(var(--heading-color)/0.5);
            margin-bottom: 0.5rem;
            font-size: 16px;
        }
    </style>
@endpush
