@php
    $contactContent = getContent('contact_us.content', true);
    $contactElement = getContent('contact_us.element', orderById: true);
@endphp
@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <div class="contact-section py-110">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-7">
                    <div class="section-heading">
                        <h2 class="section-heading__title"> {{ __(@$contactContent->data_values->heading) }}</h2>
                        <p class="section-heading__desc"> {{ __(@$contactContent->data_values->subheading) }}</p>
                    </div>
                </div>
            </div>
            <div class="row gy-4 justify-content-center">
                <div class="row gy-4 justify-content-center">
                    <div class="col-lg-4 col-sm-6">
                        <div class="contact-item h-100">
                            <div class="contact-item__shape"></div>
                            <span class="contact-item__icon"><i class="las la-envelope"></i></span>
                            <h4 class="contact-item__title"> @lang('Send Us an Email') </h4>
                            <p class="contact-item__text">
                                @lang('Reach out')
                                <a href="mailto:{{ @$contactContent->data_values->email }}"
                                    class="contact-item__link">{{ @$contactContent->data_values->email }}
                                </a>
                                @lang("and we'll get back to you in 24 hours")
                            </p>
                        </div>
                    </div>
                    <div class="col-lg-4 col-sm-6">
                        <div class="contact-item h-100">
                            <div class="contact-item__shape"></div>
                            <span class="contact-item__icon"><i class="las la-phone-volume"></i></span>
                            <h4 class="contact-item__title"> @lang('Give us a call') </h4>
                            <p class="contact-item__text">
                                @lang('In need of more assistance? Give us a call at')
                                <a href="tel:{{ str_replace(' ', '', @$contactContent->data_values->mobile_number) }}"
                                    class="contact-item__link">{{ @$contactContent->data_values->mobile_number }}
                                </a>
                            </p>
                        </div>
                    </div>
                    <div class="col-lg-4 col-sm-6">
                        <div class="contact-item h-100">
                            <div class="contact-item__shape"></div>
                            <span class="contact-item__icon"><i class="las la-map-marker-alt"></i></span>
                            <h4 class="contact-item__title"> @lang('We are located at') </h4>
                            <p class="contact-item__text ">
                                @lang('Feel free to drop by our office at your convenience') <br>
                                <span class="text--base">
                                    {{ @$contactContent->data_values->address }}
                                </span>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="contact-bottom pt-150">
                <div class="row gy-4 justify-content-center">
                    <div class="col-xl-6 col-lg-5 col-md-8 pe-lg-5 d-none d-md-block">
                        <div class="contact-bottom__thumb">
                            <img src="{{ frontendImage('contact_us', @$contactContent->data_values->image, '600x705') }}"
                                alt="@lang('img')">
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-7 ">
                        <div class="contact-form">
                            <h2 class="contact-form__title"> {{ @__($contactContent->data_values->form_heading) }} </h2>
                            <form method="post" action="{{ route('contact') }}" class="verify-gcaptcha">
                                @csrf
                                <div class="row">
                                    <div class="col-xl-6 col-lg-12 col-sm-6 form-group">
                                        <label for="name" class="form--label label-two">@lang('Your Name')</label>
                                        <input type="text" name="name" class="form--control" id="name"
                                            value="{{ old('name', @$user->fullname) }}"
                                            @if ($user && $user->profile_complete) readonly @endif required>
                                    </div>
                                    <div class="col-xl-6 col-lg-12 col-sm-6 form-group">
                                        <label for="email" class="form--label  label-two"> @lang('Email') </label>
                                        <input type="email" name="email" class="form--control" id="email"
                                            value="{{ old('email', @$user->email) }}"
                                            @if ($user) readonly @endif required>
                                    </div>
                                    <div class="col-sm-12 form-group">
                                        <label for="sub" class="form--label  label-two"> @lang('Subject') </label>
                                        <input type="text" name="subject" class="form--control" id="sub"
                                            value="{{ old('subject') }}" required>
                                    </div>
                                    <div class="col-sm-12 form-group">
                                        <label for="mes" class="form--label  label-two"> @lang('Message') </label>
                                        <textarea class="form--control" name="message" id="mes" cols="30" rows="10" required>{{ old('message') }}</textarea>
                                    </div>
                                    <div class="col-sm-12">
                                        <x-captcha />
                                    </div>
                                    <div class="col-12">
                                        <button type="submit" class="btn btn--base w-100">@lang('Submit') <span
                                                class="icon"></span></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
    @if (@$sections->secs != null)
        @foreach (json_decode($sections) as $sec)
            @include($activeTemplate . 'sections.' . $sec)
        @endforeach
    @endif
@endsection
