<!DOCTYPE html>
<html lang="en" itemscope itemtype="http://schema.org/WebPage">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title> {{ gs()->siteName(__($pageTitle)) }} </title>
    @include('partials.seo')
    <link href="{{ siteFavicon() }}" rel="@lang('icon')">
    <link rel="stylesheet" href="{{ asset('assets/global/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/global/css/all.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/global/css/line-awesome.min.css') }}">
    <link rel="stylesheet" href="{{asset('assets/global/css/iziToast_custom.css')}}">
    <link rel="stylesheet" href="{{ asset('assets/global/css/select2.min.css') }}">

    <link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/main.css') }}">
    @if (request()->routeIs('binary') || request()->is('binary*'))
        <link rel="stylesheet" href="{{ asset($activeTemplateTrue . 'css/binary-trade.css') }}">
    @endif
    <link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/custom.css') }}">
    @stack('style-lib')
    <link rel="stylesheet"
        href="{{ asset($activeTemplateTrue . 'css/color.php') }}?color={{ gs()->base_color }}&secondColor={{ gs()->secondary_color }}">
    @stack('style')
</head>
<body>
    @stack('fbComment')
    <div class="preloader-wrapper">
        <div class="preloader">
            <div class="wrapper">
                <div class="loader">
                    <div class="dot"></div>
                </div>
                <div class="loader">
                    <div class="dot"></div>
                </div>
                <div class="loader">
                    <div class="dot"></div>
                </div>
                <div class="loader">
                    <div class="dot"></div>
                </div>
                <div class="loader">
                    <div class="dot"></div>
                </div>
                <div class="loader">
                    <div class="dot"></div>
                </div>
            </div>
        </div>
    </div>

    <div class="body-overlay"></div>

    <div class="sidebar-overlay"></div>

    <a class="scroll-top"><i class="fas fa-angle-double-up"></i></a>

    <main>

        @yield('panel')

        @php
            $cookie = App\Models\Frontend::where('data_keys', 'cookie.data')->first();
        @endphp
        @if ($cookie->data_values->status == Status::ENABLE && !\Cookie::get('gdpr_cookie'))
            <!-- cookies dark version start -->
            <div class="cookies-card text-center hide">
                <div class="cookies-card__icon bg--base">
                    <i class="las la-cookie-bite"></i>
                </div>
                <p class="mt-4 cookies-card__content">{{ $cookie->data_values->short_desc }} <a href="{{ route('cookie.policy') }}"
                        class="text--base" target="_blank">@lang('Learn More')</a></p>
                <div class="cookies-card__btn mt-4">
                    <a href="javascript:void(0)" class="btn btn--base text-white w-100 policy">@lang('Allow')</a>
                </div>
            </div>
            <!-- cookies dark version end -->
        @endif

    </main>

    <script src="{{ asset('assets/global/js/jquery-3.7.1.min.js') }}"></script>
    <script src="{{ asset('assets/global/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('assets/global/js/select2.min.js') }}"></script>

    <script src="{{ asset($activeTemplateTrue . 'js/viewport.jquery.js') }}"></script>

    @if (request()->routeIs('binary') || request()->is('binary*'))
        <script src="{{ asset($activeTemplateTrue . 'js/binary-trade.js') }}"></script>
        @php
            $pusherConfig = gs('pusher_config');
        @endphp
        <script>
            window.my_pusher = {
                'app_key': "{{ base64_encode(@$pusherConfig->pusher_app_key) }}",
                'app_cluster': "{{ base64_encode(@$pusherConfig->pusher_app_cluster) }}",
                'base_url': "{{ route('home') }}"
            }
            window.allow_decimal = "{{ gs('allow_decimal_after_number') }}";
        </script>
    @endif
    <script src="{{ asset($activeTemplateTrue . 'js/main.js') }}"></script>
    @stack('script-lib')

    @include('partials.notify')

    @php echo loadExtension('tawk-chat') @endphp

    @if(gs('pn'))
        @include('partials.push_script')
    @endif

    @stack('script')

    <script>
        (function($) {
            "use strict";

            $('.policy').on('click', function() {
                $.get('{{ route('cookie.accept') }}', function(response) {
                    $('.cookies-card').addClass('d-none');
                });
            });

            setTimeout(function() {
                $('.cookies-card').removeClass('hide')
            }, 2000);

            var inputElements = $('[type=text],[type=password],[type=email],[type=number],select,textarea');
            $.each(inputElements, function(index, element) {
                element = $(element);
                element.closest('.form-group').find('label').attr('for', element.attr('name'));
                element.attr('id', element.attr('name'))
            });

            $.each($('input, select, textarea'), function(i, element) {
                var elementType = $(element);
                if (elementType.attr('type') != 'checkbox') {
                    if (element.hasAttribute('required')) {
                        $(element).closest('.form-group').find('label').addClass('required');
                    }
                }
            });

            Array.from(document.querySelectorAll('table')).forEach(table => {
                let heading = table.querySelectorAll('thead tr th');
                Array.from(table.querySelectorAll('tbody tr')).forEach((row) => {
                    Array.from(row.querySelectorAll('td')).forEach((colum, i) => {
                        colum.setAttribute('data-label', heading[i].innerText)
                    });
                });
            });

            let disableSubmission = false;
            $('.disableSubmission').on('submit', function(e) {
                if (disableSubmission) {
                    e.preventDefault()
                } else {
                    disableSubmission = true;
                }
            });

        })(jQuery);
    </script>
</body>

</html>
