@if (!$commodities->isEmpty())
    <div class="trade-table">
        <table class="table table--responsive--xxl">
            <thead>
                <tr>
                    <th> @lang('Commodities') </th>
                    <th> @lang('Current Price')</th>
                    <th>@lang('Unit')</th>
                    <th> @lang('24h')% </th>
                    <th> @lang('7d')% </th>
                    <th> @lang('Market Capital')</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                @foreach ($commodities as $commodity)
                    <tr>
                        <td>
                            <div class="commodities flex-align">
                                <div class="commodities__thumb">
                                    <img src="{{ getImage(getFilePath('commodityImage') . '/' . $commodity->image, getFileSize('commodityImage')) }}"
                                        class="fit-image" alt="@lang('Commodity Image')">
                                </div>
                                <div class="commodities__content">
                                    <h6 class="commodities__name">{{ __($commodity->name) }}</h6>
                                </div>
                            </div>
                        </td>
                        <td>
                            <div>{{ showAmount($commodity->price) }}</div>
                        </td>
                        <td>
                            {{ __($commodity->unit) }}
                        </td>
                        <td>
                            <div>
                                {{ __($commodity->twenty_four_hour_change) }}%
                                <span
                                    class="{{ $commodity->twenty_four_hour_change < 0 ? 'text--danger' : 'text--success' }}">
                                    <i
                                        class="fa-solid {{ $commodity->twenty_four_hour_change < 0 ? 'fa-arrow-trend-down' : 'fa-arrow-trend-up' }}"></i>
                                </span>
                            </div>
                        </td>
                        <td>
                            <div> {{ __($commodity->seven_day_change) }}%
                                <span class="{{ $commodity->seven_day_change < 0 ? 'text--danger' : 'text--success' }}">
                                    <i
                                        class="fa-solid {{ $commodity->seven_day_change < 0 ? 'fa-arrow-trend-down' : 'fa-arrow-trend-up' }}"></i>
                                </span>
                            </div>
                        </td>
                        <td>{{ $commodity->market_capital == 0 ? '-----' : showAmount($commodity->market_capital) }}
                        </td>
                        <td>
                            <a href="{{ route('user.trade.index') }}?commodity_id={{ $commodity->id }}"
                                class="btn btn--base btn--sm">
                                <i class="fa-solid fa-arrow-trend-up"></i> @lang('TRADE NOW')
                            </a>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
@else
    @include($activeTemplate . 'partials.empty', ['data' => 'No commodity found'])
@endif
