@php
    $footerContent = getContent('footer.content', true);
    $footerElement = getContent('social_icon.element', orderById: true);
    $pages         = App\Models\Page::where('tempname', $activeTemplate)
        ->where('is_default', Status::NO)
        ->get();
    $policyPages    = getContent('policy_pages.element', false, null, true);
    $contactContent = getContent('contact_us.content', true);
@endphp

<footer class="footer-area section-bg">
    <div class="footer-wrapper">
        <div class="container">
            <div class="footer-item-wrapper">
                <div class="footer-item">
                    <div class="footer-item__logo">
                        <a href="{{ route('home') }}"> <img src="{{ siteLogo() }}" alt="@lang('Logo')"></a>
                    </div>
                    <p class="footer-item__desc">{{ __(@$footerContent->data_values->short_details) }}</p>
                    <ul class="social-list">
                        @foreach ($footerElement as $element)
                            <li class="social-list__item">
                                <a href="{{ @$element->data_values->url }}" target="blank" class="social-list__link flex-center">
                                    @php echo @$element->data_values->icon; @endphp
                                </a>
                            </li>
                        @endforeach
                    </ul>
                </div>
                <div class="footer-item">
                    <h6 class="footer-item__title">@lang('Quick Links') </h6>
                    <ul class="footer-menu">
                        <li class="footer-menu__item"><a href="{{ route('home') }}" class="footer-menu__link"> @lang('Home') </a></li>
                        <li class="footer-menu__item"><a href="{{ route('blog') }}" class="footer-menu__link"> @lang('Blog') </a></li>
                        <li class="footer-menu__item"><a href="{{ route('contact') }}" class="footer-menu__link"> @lang('Contact') </a></li>
                    </ul>
                </div>
                <div class="footer-item">
                    <h6 class="footer-item__title">@lang('Policy Pages')</h6>
                    <ul class="footer-menu">
                        @foreach ($policyPages as $policy)
                            <li class="footer-menu__item">
                                <a href="{{ route('policy.pages', $policy->slug) }}"
                                    class="footer-menu__link">{{ __($policy->data_values->title) }}</a>
                            </li>
                        @endforeach
                    </ul>
                </div>
                <div class="footer-item">
                    <h6 class="footer-item__title">@lang('Contact Us')</h6>
                    <ul class="footer-menu">
                        <li class="footer-menu__item"><a href="mailto:{{@$contactContent->data_values->email}}" class="footer-menu__link">{{@$contactContent->data_values->email}}</a></li>
                        <li class="footer-menu__item"><a href="tel:{{str_replace(" ","",@$contactContent->data_values->mobile_number) }}" class="footer-menu__link">{{@$contactContent->data_values->mobile_number}}</a></li>
                        <li class="footer-menu__item">{{@$contactContent->data_values->address}}</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="bottom-footer">
        <div class="container">
            <div class="bottom-footer__wrapper">
                <div class="row justify-content-center">
                    <div class="col-md-6 text-center">
                        <p class="bottom-footer-text">
                            ©{{ date('Y') }} <a href="{{ route('home') }}">{{ __(gs()->site_name) }}.</a>
                            @lang('All Right Reserved').
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>
