@php
    $pages = App\Models\Page::where('tempname', $activeTemplate)
        ->where('is_default', Status::NO)
        ->get();
    $language = App\Models\Language::all();
    $selectedLang = $language->where('code', session('lang'))->first();
@endphp

<header class="header header-style-two" id="header">
    <div class="container">
        <nav class="navbar navbar-expand-lg navbar-light">
            <a class="navbar-brand logo" href="{{ route('home') }}"><img src="{{ siteLogo() }}" alt="@lang('Logo')"></a>
            <button class="navbar-toggler header-button" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent"
                aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span id="hiddenNav"><i class="las la-bars"></i></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav nav-menu  align-items-lg-center">
                    <li class="nav-item d-block d-lg-none mt-3">
                        <div class="top-button d-flex flex-wrap justify-content-between align-items-center">
                            <ul class="login-registration-list d-flex flex-wrap align-items-center">
                                @guest
                                    <li class="login-registration-list__item">
                                        <a href="{{ route('user.login') }}" class="login-registration-list__link login">@lang('Login')</a>
                                    </li>
                                    <li class="login-registration-list__item">
                                        <a href="{{ route('user.register') }}" class="login-registration-list__link register">@lang('Sign Up')</a>
                                    </li>
                                @else
                                    <li class="login-registration-list__item">
                                        <a href="{{ route('user.home') }}" class="login-registration-list__link register">@lang('Dashboard')</a>
                                    </li>
                                    @endif
                                </ul>
                                @if (gs()->multi_language)
                                    <div class="custom--dropdown">
                                        <div class="custom--dropdown__selected dropdown-list__item">
                                            <div class="thumb">
                                                <img src="{{ getImage(getFilePath('language') . '/' . @$selectedLang->image, getFileSize('language')) }}"
                                                    alt="@lang('img')">
                                            </div>
                                            <span class="text"> {{ @$selectedLang->name }} </span>
                                        </div>
                                        <ul class="dropdown-list">
                                            @foreach ($language as $lang)
                                                <li class="dropdown-list__item " data-value="{{ @$lang->code }}">
                                                    <a href="{{ route('lang', $lang->code) }}" class="thumb">
                                                        <img src="{{ getImage(getFilePath('language') . '/' . @$lang->image, getFileSize('language')) }}"
                                                            alt="@lang('image')">
                                                    </a>
                                                    <span class="text"> {{ @$lang->name }} </span>
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif
                            </div>
                        </li>
                        <li class="nav-item has-mega-menu">
                            <a class="nav-link" href="javascript:void(0)">@lang('Trade')</a>
                            <div class="mega-menu">
                                <div class="mega-menu__inner">
                                    <ul class="mega-menu-list {{ gs('future_trade') ? 'list-grid' : '' }}">
                                        @auth
                                            <li class="mega-menu-list__item mega-item-bg1">
                                                <a href="{{ route('user.trade.index') }}" class="mega-menu-list__link">
                                                    <div class="mega-menu-list__content">
                                                        <span class="mega-menu-list__title">@lang('SPOT')</span>
                                                        <p class="mega-menu-list__desc">@lang('Trade smartly with necessary Spot market tools.')</p>
                                                    </div>
                                                    <span class="mega-menu-list__icon">
                                                        <img class="fit-image" src="{{ getImage('assets/images/extra_images/bar-chart.png', null) }}">
                                                    </span>
                                                </a>
                                            </li>
                                        @else
                                            <li class="mega-menu-list__item mega-item-bg1">
                                                <a href="{{ route('user.login') }}" class="mega-menu-list__link">
                                                    <div class="mega-menu-list__content">
                                                        <span class="mega-menu-list__title">@lang('SPOT')</span>
                                                        <p class="mega-menu-list__desc">@lang('Trade smartly with necessary Spot market tools.')</p>
                                                    </div>
                                                    <span class="mega-menu-list__icon">
                                                        <img class="fit-image" src="{{ getImage('assets/images/extra_images/bar-chart.png', null) }}">
                                                    </span>
                                                </a>
                                            </li>
                                        @endauth
                                        @if (Route::has('p2p'))
                                            <li class="mega-menu-list__item mega-item-bg2">
                                                <a href="{{ route('p2p') }}" class="mega-menu-list__link">
                                                    <div class="mega-menu-list__content">
                                                        <span class="mega-menu-list__title">@lang('P2P')</span>
                                                        <p class="mega-menu-list__desc">@lang('Buy & sell crypto with your preferred payment methods.')</p>
                                                    </div>
                                                    <span class="mega-menu-list__icon">
                                                        <img class="fit-image" src="{{ getImage('assets/images/extra_images/p2p.png', null) }}">
                                                    </span>
                                                </a>
                                            </li>
                                        @endif
                                        <li class="mega-menu-list__item mega-item-bg3">
                                            <a href="{{ route('binary') }}" class="mega-menu-list__link">
                                                <div class="mega-menu-list__content">
                                                    <span class="mega-menu-list__title">@lang('Binary')</span>
                                                    <p class="mega-menu-list__desc">@lang('Binary trading predicts asset price changes over time.')</p>
                                                </div>
                                                <span class="mega-menu-list__icon">
                                                    <img class="fit-image" src="{{ getImage('assets/images/extra_images/trading.png', null) }}">
                                                </span>
                                            </a>
                                        </li>
                                        @if (gs('future_trade') && Route::has('future.trade'))
                                            <li class="mega-menu-list__item mega-item-bg4">
                                                <a href="{{ route('future.trade') }}" class="mega-menu-list__link">
                                                    <div class="mega-menu-list__content">
                                                        <span class="mega-menu-list__title">@lang('Future')</span>
                                                        <p class="mega-menu-list__desc">@lang('Futures trading is predicting if prices go up or down.')</p>
                                                    </div>
                                                    <span class="mega-menu-list__icon">
                                                        <img class="fit-image" src="{{ getImage('assets/images/extra_images/future.png') }}">
                                                    </span>
                                                </a>
                                            </li>
                                        @endif
                                    </ul>
                                </div>
                            </div>
                        </li>
                        <li class="nav-item {{ menuActive('home') }}">
                            <a class="nav-link" aria-current="page" href="{{ route('home') }}">@lang('Home')</a>
                        </li>
                        @foreach ($pages as $k => $data)
                            <li class="nav-item {{ menuActive('pages', null, $data->slug) }}">
                                <a class="nav-link" href="{{ route('pages', [$data->slug]) }}"> {{ __($data->name) }} </a>
                            </li>
                        @endforeach
                        <li class="nav-item {{ menuActive('blog') }}">
                            <a class="nav-link" href="{{ route('blog') }}">@lang('Blog')</a>
                        </li>
                        <li class="nav-item {{ menuActive('contact') }}">
                            <a class="nav-link" href="{{ route('contact') }}">@lang('Contact')</a>
                        </li>
                    </ul>
                    <div class="nav-item d-lg-block d-none ms-auto">
                        <div class="top-button d-flex flex-wrap justify-content-between align-items-center">
                            <ul class="login-registration-list d-flex flex-wrap align-items-center">
                                @guest
                                    <li class="login-registration-list__item">
                                        <a href="{{ route('user.login') }}" class="login-registration-list__link login">@lang('Login')</a>
                                    </li>
                                    <li class="login-registration-list__item">
                                        <a href="{{ route('user.register') }}" class="login-registration-list__link register">@lang('Sign Up')</a>
                                    </li>
                                @else
                                    <li class="login-registration-list__item">
                                        <a href="{{ route('user.home') }}" class="login-registration-list__link register">@lang('Dashboard')</a>
                                    </li>
                                    @endif
                                </ul>

                                @if (gs()->multi_language)
                                    <div class="custom--dropdown">
                                        <div class="custom--dropdown__selected dropdown-list__item">
                                            <div class="thumb">
                                                <img src="{{ getImage(getFilePath('language') . '/' . @$selectedLang->image, getFileSize('language')) }}"
                                                    alt="@lang('img')">
                                            </div>
                                            <span class="text"> {{ @$selectedLang->name }} </span>
                                        </div>
                                        <ul class="dropdown-list">
                                            @foreach ($language as $lang)
                                                <li class="dropdown-list__item " data-value="{{ @$lang->code }}">
                                                    <a href="{{ route('lang', $lang->code) }}" class="dropdown-list__link">
                                                        <span class="thumb">
                                                            <img src="{{ getImage(getFilePath('language') . '/' . @$lang->image, getFileSize('language')) }}"
                                                                alt="@lang('image')">
                                                        </span>
                                                        <span class="text"> {{ @$lang->name }} </span>
                                                    </a>
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </nav>
            </div>
        </header>
