@php
    $aboutContent = getContent('about.content', true);
    $aboutElement = getContent('about.element', orderById: true);
@endphp

<div class="why-choose-section py-110 section-bg">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-7">
                <div class="section-heading">
                    <h2 class="section-heading__title" data-s-break="-1"> {{ __(@$aboutContent->data_values->heading) }}
                    </h2>
                    <p class="section-heading__desc"> {{ __(@$aboutContent->data_values->subheading) }}</p>
                </div>
            </div>
        </div>
        <div class="row gy-4 ">
            <div class="col-xl-6 col-lg-5 pe-lg-5">
                <div class="why-choose__thumb">
                    <img src="{{ frontendImage('about', @$aboutContent->data_values->image, '600x452') }}"
                        alt="@lang('About Image')">
                    <a href="{{ @$aboutContent->data_values->video_link }}" class="play-button">
                        <span class="icon"><i class="fas fa-play"></i></span>
                    </a>
                </div>
            </div>
            <div class="col-xl-6 col-lg-7 ps-lg-2">
                <div class="why-choose__right">
                    <div class="row gy-4 ">
                        @foreach ($aboutElement as $element)
                            <div class="col-sm-6 col-xsm-6">
                                <div class="choose-item">
                                    <div class="choose-item__thumb">
                                        <img src="{{ frontendImage('about', @$element->data_values->image, '600x452') }}"
                                            alt="@lang('About Thumb')">
                                    </div>
                                    <div class="choose-item__content">
                                        <h5 class="choose-item__title"> {{ __(@$element->data_values->title) }}</h5>
                                        <p class="choose-item__desc">{{ __(@$element->data_values->subtitle) }}</p>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('style-lib')
    <link rel="stylesheet" href="{{ asset($activeTemplateTrue . 'css/magnific-popup.css') }}">
@endpush

@push('script-lib')
    <script src="{{ asset($activeTemplateTrue . 'js/magnific-popup.js') }}"></script>
@endpush

@push('script')
    <script>
        "use strict";
        var videoItem = $(".play-button");
        (function($) {

            if (videoItem) {
                videoItem.magnificPopup({
                    type: "iframe",
                });
            };
        })(jQuery);
    </script>
@endpush
