@php
    $commodities = App\Models\Commodity::active()->hasPrice()->orderBy('name')->take(15)->get();
    $commodityContent = getContent('commodity.content', true);
@endphp

<section class="testimonials py-110 section-bg">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-7">
                <div class="section-heading">
                    <h2 class="section-heading__title" data-s-break="1">{{ __(@$commodityContent->data_values->heading) }}
                    </h2>
                    <p class="section-heading__desc"> {{ __(@$commodityContent->data_values->subheading) }}</p>
                </div>
            </div>
            <div class="cl-12">
                @include($activeTemplate . 'partials.commodity_table')
            </div>
        </div>
    </div>
</section>
