@php
    $counterElement = getContent('counter.element', orderById: true);
@endphp
<div class="counter-up-section py-70">
    <div class="container">
        <div class="row">
            <div class="counterup-item ">
                @foreach ($counterElement as $element)
                    <div class="counterup-item__content">
                        <div class="counterup-wrapper">
                            <div class="content">
                                <div class="counterup-item__number">
                                    <h3 class="counterup-item__title mb-0">
                                        <span class="odometer" data-odometer-final="{{ @$element->data_values->total_count }}">
                                            {{ @$element->data_values->count_start }}
                                        </span>
                                        {{ __(@$element->data_values->title) }}
                                    </h3>
                                </div>
                                <span class="counterup-item__text mb-0"> {{ __(@$element->data_values->subtitle) }}</span>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</div>


@push('style-lib')
    <link rel="stylesheet" href="{{ asset($activeTemplateTrue . 'css/odometer.css') }}">
@endpush

@push('script-lib')
    <script src="{{ asset($activeTemplateTrue . 'js/odometer.min.js') }}"></script>
@endpush

@push('script')
    <script>
        "use strict";
        (function($) {
            $(".counterup-item").each(function() {
                $(this).isInViewport(function(status) {
                    if (status === "entered") {
                        for (
                            var i = 0; i < document.querySelectorAll(".odometer").length; i++
                        ) {
                            var el = document.querySelectorAll(".odometer")[i];
                            el.innerHTML = el.getAttribute("data-odometer-final");
                        }
                    }
                });
            });
        })(jQuery);
    </script>
@endpush
