@php
    $faqContent = getContent('faq.content', true);
    $faqElement = getContent('faq.element', orderById: true);
@endphp

<div class="faq-section py-110 section-bg">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-7">
                <div class="section-heading">
                    <h2 class="section-heading__title" data-s-break="1">{{ __(@$faqContent->data_values->heading) }}</h2>
                    <p class="section-heading__desc"> {{ __(@$faqContent->data_values->subheading) }} </p>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-6">
                <div class="accordion custom--accordion" id="accordionExample">
                    @foreach ($faqElement as $k=> $element)
                        @if ($loop->even)
                            <div class="accordion-item ">
                                <h5 class="accordion-header" id="heading{{ $loop->index }}">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapse{{ $loop->index }}" aria-expanded="false">
                                        {{ __(@$element->data_values->question) }}
                                    </button>
                                </h5>
                                <div id="collapse{{ $loop->index }}" class="accordion-collapse collapse @if($k==1) show @endif" aria-labelledby="heading{{ $loop->index }}"
                                    data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <p class="text">
                                            {{ __(@$element->data_values->answer) }}
                                        </p>
                                    </div>
                                </div>
                            </div>
                        @endif
                    @endforeach
                </div>
            </div>
            <div class="col-lg-6">
                <div class="accordion custom--accordion" id="accordionExampletwo">
                    @foreach ($faqElement as $element)
                        @if ($loop->odd)
                            <div class="accordion-item">
                                <h5 class="accordion-header" id="heading{{ $loop->index }}">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapse-two-{{ $loop->index }}" aria-expanded="false">
                                        {{ __(@$element->data_values->question) }}
                                    </button>
                                </h5>
                                <div id="collapse-two-{{ $loop->index }}" class="accordion-collapse collapse @if($loop->first) show @endif"
                                    aria-labelledby="heading{{ $loop->index }}" data-bs-parent="#accordionExampletwo">
                                    <div class="accordion-body">
                                        <p class="text">
                                            {{ __(@$element->data_values->answer) }}
                                        </p>
                                    </div>
                                </div>
                            </div>
                        @endif
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
