@php
    $howTradeContent = getContent('how_trade.content', true);
    $howTradeElement = getContent('how_trade.element', orderById: true);
@endphp

<div class="how-work-section py-110">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-7">
                <div class="section-heading">
                    <h2 class="section-heading__title" data-s-break="-1">{{ __(@$howTradeContent->data_values->heading) }}
                    </h2>
                    <p class="section-heading__desc"> {{ __(@$howTradeContent->data_values->subheading) }}</p>
                </div>
            </div>
        </div>
        <div class="row justify-content-center">
            <div class="col-lg-12">
                <div class="how-work">
                    @foreach ($howTradeElement as $element)
                        <div class="how-work__item active">
                            <span class="how-work__thumb">
                                <img src="{{ frontendImage('how_trade', @$element->data_values->image, '105x105') }}"
                                    alt="@lang('Image')">
                            </span>
                            <div class="how-work__content">
                                <span class="how-work__number">{{ $loop->iteration }}</span>
                                <h5 class="how-work__title"> {{ __(@$element->data_values->title) }} </h5>
                                <p class="how-work__desc">
                                    {{ __(@$element->data_values->subtitle) }}
                                </p>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
