@php
    $referralContent = getContent('referral.content', true);
    $referralElement = getContent('referral.element', orderById: true);
@endphp
<section class="referral-section pt-120 pb-60">
    <h2 class="referral-section__title">
        {{ @__($referralContent->data_values->title) }}
    </h2>
    <div class="container">
        <div class="row gy-4 align-items-center justify-content-sm-center flex-wrap-reverse">
            <div class="col-lg-6 pe-lg-5">
                <div class="referral-thumb">
                    <img src="{{ frontendImage('referral', @$referralContent->data_values->image, '600x710') }}"
                        alt="@lang('Referral Image')">
                </div>
            </div>
            <div class="col-lg-5 ps-lg-5">
                <div class="section-heading style-left">
                    <h2 class="section-heading__title"> {{ @__($referralContent->data_values->heading) }} </h2>
                    <p class="section-heading__desc"> {{ @__($referralContent->data_values->subheading) }} </p>
                </div>
                @foreach ($referralElement as $element)
                    <div class="referral-level">
                        <div class="referral-level__item">
                            <div class="referral-level__thumb">
                                <img src="{{ frontendImage('referral', @$element->data_values->image, '48x48') }}"
                                    alt="@lang('Referral Image')">
                            </div>
                            <h4 class="referral-level__rate "> {{ @__($element->data_values->title) }} <span
                                    class="text-style"> {{ @__($element->data_values->commission) }} </span></h4>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</section>
