@php
    $testimonialContent = getContent('testimonial.content', true);
    $testimonialElement = getContent('testimonial.element', orderById: true);
@endphp

<section class="testimonials py-110">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-7">
                <div class="section-heading">
                    <h2 class="section-heading__title" data-s-break="1">
                        {{ __(@$testimonialContent->data_values->heading) }}</h2>
                    <p class="section-heading__desc"> {{ __(@$testimonialContent->data_values->subheading) }}</p>
                </div>
            </div>
        </div>
        <div class="testimonial-slider">
            @foreach ($testimonialElement as $element)
                <div class="testimonails-card">
                    <div class="testimonial-item">
                        <div class="testimonial-item__info">
                            <div class="testimonial-item__thumb">
                                <img src="{{ frontendImage('testimonial', @$element->data_values->image, '60x60') }}"
                                    class="fit-image" alt="@lang('Testimonial Image')">
                            </div>
                            <div class="testimonial-item__details">
                                <h6 class="testimonial-item__name"> {{ __(@$element->data_values->name) }} </h6>
                                <span class="testimonial-item__designation"> {{ __(@$element->data_values->title) }}
                                </span>
                            </div>
                        </div>
                        <p class="testimonial-item__desc"> {{ __(@$element->data_values->comment) }} </p>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>



@push('style-lib')
    <link rel="stylesheet" href="{{ asset($activeTemplateTrue . 'css/slick.css') }}">
@endpush

@push('script-lib')
    <script src="{{ asset($activeTemplateTrue . 'js/slick.min.js') }}"></script>
@endpush

@push('script')
    <script>
        "use strict";
        (function($) {
            $(".testimonial-slider").slick({
                slidesToShow: 3,
                slidesToScroll: 1,
                autoplay: true,
                autoplaySpeed: 2000,
                speed: 1500,
                dots: true,
                pauseOnHover: true,
                arrows: false,
                prevArrow: '<button type="button" class="slick-prev"><i class="fas fa-long-arrow-alt-left"></i></button>',
                nextArrow: '<button type="button" class="slick-next"><i class="fas fa-long-arrow-alt-right"></i></button>',
                responsive: [{
                        breakpoint: 1199,
                        settings: {
                            arrows: false,
                            slidesToShow: 2,
                            dots: true,
                        },
                    },
                    {
                        breakpoint: 991,
                        settings: {
                            arrows: false,
                            slidesToShow: 2,
                        },
                    },
                    {
                        breakpoint: 464,
                        settings: {
                            arrows: false,
                            slidesToShow: 1,
                        },
                    },
                ],
            });
        })(jQuery);
    </script>
@endpush
