@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="dashboard-body">
        <div class="row gy-4">
            <div class="col-12">
                <div class="d-flex  flex-wrap align-items-center justify-content-between gap-2 all-asset">
                    <div class="pagetitle">
                        <h4 class="mb-0">{{ __($pageTitle) }}</h4>
                    </div>
                    <div class="d-flex gap-3 flex-wrap align-items-center">
                        <h5 class="text-end mb-0">
                            @lang('Aggregate Asset Value'):
                            <span class="text--base">
                                {{ showAmount($totalAssetBalance) }}
                            </span>
                        </h5>

                        <form>
                            <div class="input-group">
                                <input type="search" name="search" class="form-control form--control"
                                    placeholder="@lang('Search')..." value="{{ request()->search ?? '' }}">
                                <button class="btn btn--base input-group-text"><i class="fa fa-search"></i></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-12">
                @if (!$assets->isEmpty())
                    <div class="dashboard-table">
                        <table class="table table--responsive--xl">
                            <thead>
                                <tr>
                                    <th>@lang('Name')</th>
                                    <th>@lang('Available Stock')</th>
                                    <th>@lang('Total Price')</th>
                                    <th>@lang('Buying Price/Unit')</th>
                                    <th>@lang('Current Price/Unit')</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($assets as $asset)
                                    <tr>
                                        <td>
                                            <div class="commodities flex-align">
                                                <div class="commodities__thumb">
                                                    <img src="{{ getImage(getFilePath('commodityImage') . '/' . $asset->commodity->image, getFileSize('commodityImage')) }}"
                                                        class="fit-image" alt="@lang('Commodity Image')">
                                                </div>
                                                <div class="commodities__content">
                                                    <h6 class="commodities__name">{{ __($asset->commodity->name) }}</h6>
                                                </div>
                                            </div>
                                        </td>

                                        <td>
                                            {{ showAmount($asset->quantity, 8, currencyFormat: false) }}
                                            {{ __($asset->commodity->unit) }}
                                        </td>

                                        <td>
                                            {{ showAmount($asset->commodity->price * $asset->quantity) }}
                                        </td>

                                        <td>
                                            {{ showAmount($asset->price) }}
                                        </td>

                                        <td>
                                            {{ showAmount($asset->commodity->price) }}
                                        </td>

                                        <td>
                                            <a href="{{ route('user.trade.index') }}?commodity_id={{ $asset->commodity_id }}"
                                                class="btn btn--base btn--sm">
                                                <i class="fas fa-chart-bar"></i> @lang('TRADE NOW')
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @if ($assets->hasPages())
                        <div class="card-footer">
                            {{ $assets->links() }}
                        </div>
                    @endif
                @else
                    @include($activeTemplate . 'partials.empty', ['data' => 'No Asset Found'])
                @endif
            </div>
        </div>

    </div>

@endsection
