@extends($activeTemplate . 'layouts.app')
@section('panel')
    @php
        $credentials = gs()->socialite_credentials;
        $loginContent = @getContent('login.content', true)->data_values;
    @endphp
    <section class="account login-section">
        <div class="account-inner">
            <div class="account__left">
                <div class="account-thumb">
                    <img src="{{ frontendImage('login', @$loginContent->image, '836x822') }}" alt="Image" />
                </div>
            </div>
            <div class="account__right">
                <div class="account__content">
                    <div class="account-header-wrapper d-flex align-items-center justify-content-between gap-2 flex-wrap">
                        <a class="navbar-brand logo" href="{{ route('home') }}"><img src="{{ siteLogo() }}"
                                alt="@lang('logo')"></a>
                        @if (gs('registration'))
                            <div class="top-button d-flex  justify-content-between align-items-center">
                                <ul class="login-registration-list d-flex flex-wrap align-items-center">
                                    <li class="login-registration-list__item"> @lang('Don\'t have an account?')</li>
                                    <li class="login-registration-list__item">
                                        <a href="{{ route('user.register') }}"
                                            class="login-registration-list__link register">
                                            @lang('Sign Up') <i class="fas fa-angle-right"></i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        @endif

                    </div>

                    <div class="account-form">
                        <div class="account-form__wrapper">
                            <h3 class="account-form__title mb-2">{{ __(@$loginContent->heading) }}</h3>
                            <p class="account-form__desc">{{ __(@$loginContent->subheading) }}</p>
                        </div>
                        <form method="POST" action="{{ route('user.login') }}" class="verify-gcaptcha">
                            @csrf
                            <div class="row">
                                <div class="col-sm-12 form-group">
                                    <label class="form--label label-two">@lang('Username or Email')</label>
                                    <input type="text" class="form--control form-three" id="email" name="username"
                                        value="{{ old('username') }}" required>
                                </div>
                                <div class="col-sm-12 form-group">
                                    <div class="d-flex flex-wrap justify-content-between">
                                        <label for="password" class="form--label label-two">@lang('Password')</label>
                                        <a href="{{ route('user.password.request') }}"
                                            class="forgot-password text--base">@lang('Forgot Your Password?')</a>
                                    </div>
                                    <div class="position-relative">
                                        <input id="password" type="password" class="form-control form--control  form-three"
                                            name="password" required>
                                        <span class="password-show-hide fas toggle-password fa-eye-slash"
                                            id="#password"></span>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <x-captcha />
                                </div>
                                <div class="mb-3 mb-md-5 col-sm-12">
                                    <button type="submit" class="btn btn--base w-100">@lang('Login')</button>
                                </div>
                                @include($activeTemplate . 'partials.social_login')
                            </div>
                        </form>
                    </div>
                </div>

            </div>
        </div>
    </section>
@endsection

@push('style')
    <style>
        .form-group {
            margin-bottom: 1.5rem !important;
        }
    </style>
@endpush
