@extends($activeTemplate . 'layouts.app')
@section('panel')
    @php
        $credentials = gs()->socialite_credentials;
        $registerContent = @getContent('register.content', true)->data_values;
        $policyPages = getContent('policy_pages.element', false, null, true);
    @endphp
    @if (gs('registration'))
        <section class="account ">
            <div class="account-inner">
                <div class="account__left">
                    <div class="account-thumb">
                        <img src="{{ frontendImage('register', @$registerContent->image, '865x920') }}"
                            alt="@lang('image')" />
                    </div>
                </div>
                <div class="account__right">
                    <div class="account__content">
                        <div
                            class="account-header-wrapper d-flex align-items-center justify-content-between gap-2 flex-wrap">
                            <a class="navbar-brand logo" href="{{ route('home') }}"><img src="{{ siteLogo() }}"
                                    alt="@lang('logo')"></a>
                            <div class="top-button d-flex justify-content-between align-items-center">
                                <ul class="login-registration-list d-flex flex-wrap align-items-center">
                                    <li class="login-registration-list__item"> @lang('Already have an account?')</li>
                                    <li class="login-registration-list__item">
                                        <a href="{{ route('user.login') }}" class="login-registration-list__link register">
                                            @lang('Sign In') <i class="fas fa-angle-right"></i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="account-form">
                            <div class="account-form__wrapper">
                                <h3 class="account-form__title mb-2">{{ __(@$registerContent->heading) }}</h3>
                                <p class="account-form__desc">{{ __(@$registerContent->subheading) }}</p>
                            </div>
                            <form action="{{ route('user.register') }}" method="POST"
                                class="verify-gcaptcha disableSubmission">
                                @csrf
                                <div class="row">
                                    @if (session()->get('reference') != null)
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="referenceBy" class="form-label">@lang('Reference by')</label>
                                                <input type="text" name="referBy" id="referenceBy"
                                                    class="form--control form-three"
                                                    value="{{ session()->get('reference') }}" readonly>
                                            </div>
                                        </div>
                                    @endif
                                    <div class="col-sm-6 form-group">
                                        <label class="form--label label-two">@lang('First Name')</label>
                                        <input type="text" class="form--control form-three" id="firstname"
                                            name="firstname" value="{{ old('firstname') }}" required>
                                    </div>
                                    <div class="col-sm-6 form-group">
                                        <label class="form--label label-two">@lang('Last Name')</label>
                                        <input type="text" class="form--control form-three" id="lastname"
                                            name="lastname" value="{{ old('lastname') }}" required>
                                    </div>
                                    <div class="col-sm-12 form-group">
                                        <label class="form--label label-two">@lang('Email')</label>
                                        <input type="text" class="form--control form-three checkUser" id="email"
                                            name="email" value="{{ old('email') }}" required>
                                    </div>

                                    <div class="col-sm-6 form-group">
                                        <div class="d-flex flex-wrap justify-content-between">
                                            <label for="password" class="form--label label-two">@lang('Password')</label>
                                        </div>
                                        <div class="position-relative">
                                            <input id="password" type="password"
                                                class="form-control form--control  form-three @if (gs('secure_password')) secure-password @endif "
                                                name="password" required>
                                            <span class="password-show-hide fas toggle-password fa-eye-slash"
                                                id="#password"></span>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 form-group">
                                        <label for="password_confirmation" class="form--label label-two"> @lang('Confirm Password')
                                        </label>
                                        <div class="position-relative">
                                            <input id="password_confirmation" type="password"
                                                class="form-control form--control form-three" name="password_confirmation"
                                                required>
                                            <span class="password-show-hide fas toggle-password fa-eye-slash"
                                                id="#password_confirmation">
                                            </span>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <x-captcha />
                                    </div>

                                    @if (gs('agree'))
                                        <div class="col-sm-12 form-group">
                                            <div class="form--check">
                                                <input class="form-check-input" type="checkbox" @checked(old('agree'))
                                                    name="agree" required id="agree">
                                                <div class="form-check-label">
                                                    <label for="agree">@lang('I agree with')</label>
                                                    <span>
                                                        @foreach ($policyPages as $policy)
                                                            <a
                                                                href="{{ route('policy.pages', $policy->slug) }}">{{ __(@$policy->data_values->title) }}</a>
                                                            @if (!$loop->last)
                                                                ,
                                                            @endif
                                                        @endforeach
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    @endif

                                    <div class="mb-3 mb-md-5 col-sm-12">
                                        <button type="submit" id="recaptcha" class="btn btn--base w-100">
                                            @lang('Sign Up') </button>
                                    </div>

                                    <div class="col-12">
                                        @include($activeTemplate . 'partials.social_login')
                                    </div>

                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @else
        @include($activeTemplate . 'partials.registration_disabled')

    @endif

    <div class="modal custom--modal" id="existModalCenter" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="existModalLongTitle">@lang('You are with us')</h5>
                    <span role="button" class="close" data-bs-dismiss="modal">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <h6 class="text-center">@lang('You already have an account please Login ')</h6>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn--dark btn--sm"
                        data-bs-dismiss="modal">@lang('Close')</button>
                    <a href="{{ route('user.login') }}" class="btn btn--base btn--sm">@lang('Login')</a>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('style')
    <style>
        .register-disable {
            height: 100vh;
            width: 100%;
            background-color: #fff;
            color: black;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .register-disable-image {
            max-width: 300px;
            width: 100%;
            margin: 0 auto 32px;
        }

        .register-disable-title {
            color: rgb(0 0 0 / 80%);
            font-size: 42px;
            margin-bottom: 18px;
            text-align: center
        }

        .register-disable-icon {
            font-size: 16px;
            background: rgb(255, 15, 15, .07);
            color: rgb(255, 15, 15, .8);
            border-radius: 3px;
            padding: 6px;
            margin-right: 4px;
        }

        .register-disable-desc {
            color: rgb(0 0 0 / 50%);
            font-size: 18px;
            max-width: 565px;
            width: 100%;
            margin: 0 auto 32px;
            text-align: center;
        }
    </style>
@endpush
@if (gs('secure_password'))
    @push('script-lib')
        <script src="{{ asset('assets/global/js/secure_password.js') }}"></script>
    @endpush
@endif

@push('script')
    <script>
        "use strict";
        (function($) {

            $('.checkUser').on('focusout', function(e) {
                var url = '{{ route('user.checkUser') }}';
                var value = $(this).val();
                var token = '{{ csrf_token() }}';

                var data = {
                    email: value,
                    _token: token
                }

                $.post(url, data, function(response) {
                    if (response.data != false) {
                        $('#existModalCenter').modal('show');
                    }
                });
            });
        })(jQuery);
    </script>
@endpush
