@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="dashboard-body">
        <div class="all-asset">
            <div class="notice"></div>

            @php
                $kyc = getContent('kyc.content', true);
            @endphp

            @if (auth()->user()->kv == Status::KYC_UNVERIFIED && auth()->user()->kyc_rejection_reason)
                <div class="alert-item-wrapper mb-4">
                    <div class="alert  alert--danger" role="alert">
                        <div class="d-flex justify-content-between dashboard-widget__btn">
                            <h4 class="alert-heading alert__title">@lang('KYC Documents Rejected')</h4>
                            <button class="btn btn--sm btn-outline--base" data-bs-toggle="modal"
                                data-bs-target="#kycRejectionReason">@lang('Show Reason')</button>
                        </div>
                        <hr>
                        <p class="mb-0">{{ __(@$kyc->data_values->reject) }} <a
                                href="{{ route('user.kyc.form') }}">@lang('Click Here to Re-submit Documents')</a>.</p>
                        <br>
                        <a href="{{ route('user.kyc.data') }}">@lang('See KYC Data')</a>
                    </div>
                </div>
            @elseif(auth()->user()->kv == Status::KYC_UNVERIFIED)
                <div class="alert-item-wrapper mb-4">
                    <div class="alert alert--info" role="alert">
                        <h4 class="alert-heading alert__title">@lang('KYC Verification required')</h4>
                        <hr>
                        <p class="mb-0">{{ __(@$kyc->data_values->required) }} <a
                                href="{{ route('user.kyc.form') }}">@lang('Click Here to Submit Documents')</a></p>
                    </div>
                </div>
            @elseif(auth()->user()->kv == Status::KYC_PENDING)
                <div class="alert-item-wrapper mb-4">
                    <div class="alert alert--warning" role="alert">
                        <h4 class="alert-heading alert__title">@lang('KYC Verification pending')</h4>
                        <hr>
                        <p class="mb-0">{{ __(@$kyc->data_values->pending) }} <a
                                href="{{ route('user.kyc.data') }}">@lang('See KYC Data')</a></p>
                    </div>
                </div>
            @endif

            <div class="row gy-4 justify-content-center dashboard-widget-wrapper">
                <div class="col-xxl-3 col-xl-4 col-lg-6 col-md-4 col-sm-6 col-xsm-6">
                    <a href="{{ route('user.transactions') }}" class="dashboard-widget d-block">
                        <div class="dashboard-widget__thumb flex-center">
                            <img src="{{ getImage($activeTemplateTrue . 'images/thumbs/d-1.png') }}"
                                alt="@lang('img')">
                        </div>
                        <div class="dashboard-widget__content">
                            <h3 class="dashboard-widget__number">
                                {{ showAmount($user->balance) }}
                            </h3>
                            <p class="dashboard-widget__text"><span>@lang('Balance')</span></p>
                        </div>
                    </a>
                </div>
                <div class="col-xxl-3 col-xl-4 col-lg-6 col-md-4 col-sm-6 col-xsm-6">
                    <a href="{{ route('user.deposit.history') }}" class="dashboard-widget d-block">
                        <div class="dashboard-widget__thumb flex-center">
                            <img src="{{ getImage($activeTemplateTrue . 'images/thumbs/d-2.png') }}"
                                alt="@lang('img')">
                        </div>
                        <div class="dashboard-widget__content">
                            <h3 class="dashboard-widget__number">
                                {{ showAmount($user->deposits()->successful()->sum('amount')) }}
                            </h3>
                            <p class="dashboard-widget__text">
                                <span> @lang('Total Deposit')</span>
                            </p>
                        </div>
                    </a>
                </div>
                <div class="col-xxl-3 col-xl-4 col-lg-6 col-md-4 col-sm-6 col-xsm-6">
                    <a href="{{ route('user.withdraw.history') }}" class="dashboard-widget d-block">
                        <div class="dashboard-widget__thumb flex-center">
                            <img src="{{ getImage($activeTemplateTrue . 'images/thumbs/d-3.png') }}"
                                alt="@lang('img')">
                        </div>
                        <div class="dashboard-widget__content">
                            <h3 class="dashboard-widget__number">
                                {{ showAmount($user->withdrawals()->approved()->sum('amount')) }}
                            </h3>
                            <p class="dashboard-widget__text"><span>@lang('Total Withdraw')</span></p>
                        </div>
                    </a>
                </div>
                <div class="col-xxl-3 col-xl-4 col-lg-6 col-md-4 col-sm-6 col-xsm-6">
                    <a href="{{ route('user.referrals') }}" class="dashboard-widget d-block">
                        <div class="dashboard-widget__thumb flex-center">
                            <img src="{{ getImage($activeTemplateTrue . 'images/thumbs/d-4.png') }}"
                                alt="@lang('img')">
                        </div>
                        <div class="dashboard-widget__content">
                            <h3 class="dashboard-widget__number">
                                {{ showAmount($user->ref_earn) }}
                            </h3>
                            <p class="dashboard-widget__text"><span>@lang('Referral Earning')</span></p>
                        </div>
                    </a>
                </div>
                @if (!$commodities->isEmpty())
                    <div class="col-12">
                        <h4 class="trade-table__title mb-0"> @lang('Commodities') </h4>
                    </div>
                    <div class="col-sm-12">
                        @include($activeTemplate . 'partials.commodity_table')
                    </div>
                @endif
            </div>
        </div>
    </div>

    @if (auth()->user()->kv == Status::KYC_UNVERIFIED && auth()->user()->kyc_rejection_reason)
        <div class="modal custom--modal fade" id="kycRejectionReason">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">@lang('KYC Document Rejection Reason')</h5>
                        <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <i class="las la-times"></i>
                        </span>
                    </div>
                    <div class="modal-body">
                        <p>{{ auth()->user()->kyc_rejection_reason }}</p>
                    </div>
                </div>
            </div>
        </div>
    @endif
@endsection
