@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="dashboard-body">
        <div class="row gy-4 justify-content-end">
            <div class="col-12">
                <div class=" d-flex  flex-wrap align-items-center justify-content-between gap-2 all-asset">
                    <div class="pagetitle">
                        <h4 class="mb-0">{{ __($pageTitle) }}</h4>
                    </div>
                    <div class="d-flex gap-2 flex-wrap">
                        <form>
                            <div class="input-group">
                                <input type="search" name="search" class="form-control form--control"
                                    placeholder="@lang('Search')..." value="{{ request()->search ?? '' }}">
                                <button class="btn btn--base input-group-text"><i class="fa fa-search"></i></button>
                            </div>
                        </form>
                        <div>
                            <a href="{{ route('user.deposit.index') }}" class="btn btn--base">
                                <i class="las la-plus"></i> @lang('New Deposit')
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12">
                @if (!$deposits->isEmpty())
                    <div class="dashboard-table">
                        <table class="table table--responsive--xl">
                            <thead>
                                <tr>
                                    <th>@lang('Gateway | Transaction')</th>
                                    <th>@lang('Initiated')</th>
                                    <th>@lang('Amount')</th>
                                    <th>@lang('Conversion')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Details')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($deposits as $deposit)
                                    <tr>
                                        <td>
                                            <span class="fw-bold">
                                                <span class="text--base">
                                                    @if ($deposit->method_code < 5000)
                                                        {{ __(@$deposit->gateway->name) }}
                                                    @else
                                                        @lang('Google Pay')
                                                    @endif
                                                </span>
                                            </span>
                                            <br>
                                            <small> {{ $deposit->trx }} </small>
                                        </td>

                                        <td>
                                            {{ showDateTime($deposit->created_at) }}<br>{{ diffForHumans($deposit->created_at) }}
                                        </td>
                                        <td class="text-center">
                                            {{ showAmount($deposit->amount) }} + <span class="text--danger"
                                                data-bs-toggle="tooltip"
                                                title="@lang('Processing Charge')">{{ showAmount($deposit->charge) }} </span>
                                            <br>
                                            <strong data-bs-toggle="tooltip" title="@lang('Amount with charge')">
                                                {{ showAmount($deposit->amount + $deposit->charge) }}
                                            </strong>
                                        </td>
                                        <td class="text-center">
                                            {{ showAmount(1) }} = {{ showAmount($deposit->rate, currencyFormat: false) }}
                                            {{ __($deposit->method_currency) }}
                                            <br>
                                            <strong>{{ showAmount($deposit->final_amount, currencyFormat: false) }}
                                                {{ __($deposit->method_currency) }}</strong>
                                        </td>
                                        <td>
                                            @php echo $deposit->statusBadge @endphp
                                        </td>
                                        @php
                                            $details = [];
                                            if ($deposit->method_code >= 1000 && $deposit->method_code <= 5000) {
                                                foreach (@$deposit->detail ?? [] as $key => $info) {
                                                    $details[] = $info;
                                                    if ($info->type == 'file') {
                                                        $details[$key]->value = route(
                                                            'user.download.attachment',
                                                            encrypt(getFilePath('verify') . '/' . $info->value),
                                                        );
                                                    }
                                                }
                                            }
                                        @endphp
                                        <td>
                                            @if ($deposit->method_code >= 1000 && $deposit->method_code <= 5000)
                                                <a href="javascript:void(0)" class="btn btn--base btn--sm detailBtn"
                                                    data-info="{{ json_encode($details) }}"
                                                    @if ($deposit->status == Status::PAYMENT_REJECT) data-admin_feedback="{{ $deposit->admin_feedback }}" @endif>
                                                    <i class="fas fa-desktop"></i>
                                                </a>
                                            @else
                                                <button type="button" class="btn btn--success btn--sm"
                                                    data-bs-toggle="tooltip" title="@lang('Automatically processed')">
                                                    <i class="fas fa-check"></i>
                                                </button>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    {{ paginateLinks($deposits) }}
                @else
                    @include($activeTemplate . 'partials.empty', ['data' => 'No deposit found'])
                @endif
            </div>
        </div>
    </div>

    {{-- APPROVE MODAL --}}
    <div id="detailModal" class="modal fade custom--modal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('Details')</h5>
                    <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <ul class="list-group list--group userData mb-2">
                    </ul>
                    <div class="feedback"></div>
                </div>
            </div>
        </div>
    </div>

@endsection


@push('script')
    <script>
        (function($) {
            "use strict";
            $('.detailBtn').on('click', function() {
                var modal = $('#detailModal');

                var userData = $(this).data('info');
                var html = '';
                if (userData) {
                    userData.forEach(element => {
                        if (element.type != 'file') {
                            html += `
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <span>${element.name}</span>
                                <span">${element.value}</span>
                            </li>`;
                        } else {
                            html += `
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <span>${element.name}</span>
                                <span"><a href="${element.value}"><i class="fa-regular fa-file"></i> @lang('Attachment')</a></span>
                            </li>`;
                        }
                    });
                }

                modal.find('.userData').html(html);

                if ($(this).data('admin_feedback') != undefined) {
                    var adminFeedback = `
                        <div class="my-3">
                            <strong>@lang('Admin Feedback')</strong>
                            <p>${$(this).data('admin_feedback')}</p>
                        </div>
                    `;
                } else {
                    var adminFeedback = '';
                }

                modal.find('.feedback').html(adminFeedback);


                modal.modal('show');
            });

            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[title], [data-title], [data-bs-title]'))
            tooltipTriggerList.map(function(tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl)
            });

        })(jQuery);
    </script>
@endpush
