@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="dashboard-body">
        <div class="row justify-content-center gy-4">
            <div class=" d-flex  flex-wrap align-items-center justify-content-between gap-2 all-asset">
                <div class="pagetitle">
                    <h4 class="mb-0">{{ __($pageTitle) }}</h4>
                </div>
                <form>
                    <div class="input-group">
                        <input type="search" name="search" class="form-control form--control" placeholder="@lang('Commodity Name')"
                            value="{{ request()->search ?? '' }}">
                        <button class="btn btn--base input-group-text"><i class="fa fa-search"></i></button>
                    </div>
                </form>
            </div>
            <div class="col-xl-12">
                @if (!$trades->isEmpty())
                    <div class="trade-table">
                        <table class="table table--responsive--xxl">
                            <thead>
                                <tr>
                                    <th> @lang('Commodity') </th>
                                    <th> @lang('Type') </th>
                                    <th> @lang('Quantity')</th>
                                    <th> @lang('Unit Price')</th>
                                    <th> @lang('Total Price')</th>
                                    <th>@lang('Date')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($trades as $trade)
                                    <tr>
                                        <td>
                                            <div class="commodities flex-align">
                                                <div class="commodities__thumb">
                                                    <img src="{{ getImage(getFilePath('commodityImage') . '/' . @$trade->commodity->image, getFileSize('commodityImage')) }}"
                                                        class="fit-image" alt="@lang('Commodity Image')">
                                                </div>
                                                <div class="commodities__content">
                                                    <h6 class="commodities__name">{{ __(@$trade->commodity->name) }}</h6>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            @if ($trade->type == Status::TRADE_TYPE_BUY)
                                                <span class="text--success">@lang('Buy')</span>
                                            @else
                                                <span class="text--danger">@lang('Sell')</span>
                                            @endif
                                        </td>
                                        <td>
                                            {{ showAmount($trade->quantity, 8, currencyFormat: false) }}
                                            {{ __($trade->commodity->unit) }}
                                        </td>
                                        <td>
                                            <div>
                                                {{ gs()->cur_sym }}{{ showAmount($trade->price, currencyFormat: false) }}/{{ __($trade->commodity->unit) }}
                                            </div>
                                        </td>
                                        <td>{{ showAmount($trade->total_cost) }}</td>
                                        <td>
                                            <div>
                                                {{ showDateTime($trade->created_at) }} <br>
                                                {{ diffForHumans($trade->created_at) }}
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    {{ paginateLinks($trades) }}
                @else
                    @include($activeTemplate . 'partials.empty', ['data' => 'No trading found'])
                @endif
            </div>
        </div>
    </div>
@endsection
