@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="dashboard-body">
        <div class="row justify-content-center">
            <div class="col-xl-8 col-lg-10">
                <div class="d-flex flex-wrap justify-content-between gap-2 mb-4 align-items-center all-asset">
                    <h4 class="trade-form__title mb-0"> @lang('New Trade') </h4>
                    <div>
                        <a href="{{ route('user.trade.history') }}" class="btn btn-outline--base btn--sm">
                            <i class="las la-list"></i> @lang('Trade History')
                        </a>
                    </div>
                </div>
                <div class="trade-form">
                    <form action="{{ route('user.trade.store') }}" method="post">
                        @csrf
                        <div class="row">
                            <div class="col-xl-6 col-sm-6 form-group">
                                <label class="form--label"> @lang('Commodity Name') </label>
                                <select class="custom-select country-select" name="commodity" required>
                                    <option value="">@lang('Select')</option>
                                    @foreach ($commodities as $commodity)
                                        <option
                                            data-image="{{ getImage(getFilePath('commodityImage') . '/' . $commodity->image, getFileSize('commodityImage')) }}"
                                            value="{{ $commodity->id }}" @selected(old('commodity') == $commodity->id || request()->query('commodity_id') == $commodity->id)
                                            data-commodity="{{ $commodity }}">
                                            {{ __($commodity->name) }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-xl-6 col-sm-6 form-group">
                                <label class="form--label"> @lang('Trade Type') </label>
                                <select class="custom-select gateway-select form-three" name="type">
                                    <option value="{{ Status::TRADE_TYPE_BUY }}">
                                        @lang('Buy')
                                    </option>
                                    <option value="{{ Status::TRADE_TYPE_SELL }}">
                                        @lang('Sale')
                                    </option>
                                </select>
                            </div>
                            <div class="col-xl-6 col-sm-6 form-group">
                                <label class="form--label"> @lang('Amount') </label>
                                <div class="input-group mb-2">
                                    <input type="number" class="form-control form--control form-three amount"
                                        step="any" name="amount" value="{{ old('amount') }}" id="amount" required>
                                    <span class="input-group-text bg-style currency">{{ __(gs()->cur_text) }}</span>
                                </div>
                                <span class="text--base fs-14 avl-balance">
                                    @lang('Available balance is'): {{ showAmount(auth()->user()->balance) }}
                                </span>
                                <span class="text--base balance-sperator d-none">|</span>
                                <span class="text--base fs-14 d-none commodity-price-wrapper mb-2">
                                    @lang('Price'): <span class="commodity-price"></span>
                                </span>
                            </div>
                            <div class="col-xl-6 col-sm-6 form-group">
                                <label class="form--label"> @lang('Quantity') </label>
                                <div class="input-group mb-2">
                                    <input type="number" class="form-control form--control form-three amount"
                                        name="qty" id="qty" step="any">
                                    <span class="input-group-text bg-style unit"></span>
                                </div>
                                <span class="text--base fs-14 d-none commodity-qty-wrapper">@lang('Available quantity is'): <span
                                        class="commodity-qty"></span></span>
                            </div>
                            <div class="col-12">
                                <button class="btn btn--base w-100">
                                    @lang('Submit')
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div>
@endsection

@push('style-lib')
    <link rel="stylesheet" href="{{ asset($activeTemplateTrue . 'css/custom-select.css') }}" />
@endpush

@push('script')
    <script src="{{ asset($activeTemplateTrue . 'js/custom-select.js') }}"></script>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";

            $(".country-select").customSelect({
                search: true
            });
            $(".gateway-select").customSelect();

            var commodityPrice, commodityId;
            var tradeType = 1;

            $('select[name=commodity]').on("change", function() {

                if (!$(this).val()) return;

                var resource = $('select[name=commodity] option:selected').data('commodity');
                var unit = resource.unit;

                commodityPrice = parseFloat(resource.price);
                commodityId = resource.id;

                $(".commodity-price").text(`${commodityPrice.toFixed(2)} {{ __(gs()->cur_text) }} / ${unit}`);
                $(".commodity-price-wrapper").removeClass('d-none')
                $('.unit').text(unit);

                balanceSperator();
                getCommodityQty();

            }).change();

            $('select[name=type]').on("change", function() {

                tradeType = $(this).val();
                if (tradeType == 2) {
                    $('.avl-balance').addClass('d-none');
                } else {
                    $('.avl-balance').removeClass('d-none');
                }

                balanceSperator();
                getCommodityQty();
            });

            $('input[name=amount]').on('input', function() {
                if (!commodityPrice) return;
                var amount = parseFloat($(this).val() || 1);
                var quantity = amount / commodityPrice;
                $('input[name=qty]').val(quantity.toFixed(8));
            });

            $('input[name=qty]').on('input', function() {
                if (!commodityPrice) return;
                var quantity = parseFloat($(this).val());
                var amount = quantity * commodityPrice;
                $('input[name=amount]').val(amount.toFixed(2));
            });

            function getCommodityQty() {

                if (!tradeType || tradeType != 2 || !commodityId) {
                    $('.commodity-qty-wrapper').addClass('d-none');
                    return false;
                };

                $.ajax({
                    url: '{{ route('user.trade.asset.balance') }}',
                    method: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        commodity: commodityId
                    },
                    success: function(response) {
                        if (response.success) {
                            $('.commodity-qty').text(response.balance);
                            $('.commodity-qty-wrapper').removeClass('d-none');
                        } else {
                            notify('error', response.message);
                        }
                    }
                });
            }

            function balanceSperator() {
                if (commodityId && tradeType == 1) {
                    $('.balance-sperator').removeClass('d-none');
                } else {
                    $('.balance-sperator').addClass('d-none');
                }
            }

        })(jQuery);
    </script>
@endpush
