@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="dashboard-body">
        <div class="row gy-4">
            <div class="col-12">
                <div class="all-asset">
                    <div class="pagetitle mb-4 ">
                        <h4 class="mb-0">{{ __($pageTitle) }}</h4>
                    </div>
                    <div class="show-filter mb-3 text-end">
                        <button type="button" class="btn btn--base showFilterBtn btn-sm"><i class="las la-filter"></i>
                            @lang('Filter')</button>
                    </div>
                </div>
                <div class="card custom--card card-two responsive-filter-card">
                    <div class="card-body">
                        <form>
                            <div class="d-flex flex-wrap gap-3">
                                <div class="flex-grow-1">
                                    <label class="form--label">@lang('Transaction Number')</label>
                                    <input type="text" name="search" value="{{ request()->search }}"
                                        class="form--control">
                                </div>
                                <div class="flex-grow-1">
                                    <label class="form--label">@lang('Type')</label>
                                    <select name="trx_type" class="form--control select2"
                                        data-minimum-results-for-search="-1">
                                        <option value="">@lang('All')</option>
                                        <option value="+" @selected(request()->trx_type == '+')>@lang('Plus')</option>
                                        <option value="-" @selected(request()->trx_type == '-')>@lang('Minus')</option>
                                    </select>
                                </div>
                                <div class="flex-grow-1">
                                    <label class="form--label">@lang('Remark')</label>
                                    <select class="form--control select2" name="remark">
                                        <option value="">@lang('Any')</option>
                                        @foreach ($remarks as $remark)
                                            <option value="{{ $remark->remark }}" @selected(request()->remark == $remark->remark)>
                                                {{ __(keyToTitle($remark->remark)) }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="flex-grow-1">
                                    <label class="form--label">@lang('Commodity')</label>
                                    <select class="form--control select2" name="commodity_id">
                                        <option value="" @selected(request()->commodity_id == '')>@lang('All')</option>
                                        @foreach ($commodities as $commodity)
                                            <option value="{{ $commodity->commodity_id }}" @selected(request()->commodity_id == $commodity->commodity_id)>
                                                {{ __($commodity->commodity->name ?? '') }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="flex-grow-1 align-self-end">
                                    <button class="btn btn--base w-100">@lang('Filter')</button>
                                </div>
                            </div>


                        </form>
                    </div>
                </div>
            </div>
            <div class="col-12">
                @if (!$transactions->isEmpty())
                    <div class="dashboard-table">
                        <table class="table table--responsive--xl">
                            <thead>
                                <tr>
                                    <th>@lang('Trx')</th>
                                    <th>@lang('Transacted')</th>
                                    <th>@lang('Amount')</th>
                                    <th>@lang('Post Balance')</th>
                                    <th>@lang('Detail')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($transactions as $trx)
                                    <tr>
                                        <td>
                                            <strong>{{ $trx->trx }}</strong>
                                        </td>

                                        <td>
                                            {{ showDateTime($trx->created_at) }}<br>{{ diffForHumans($trx->created_at) }}
                                        </td>
                                        <td class="budget">
                                            <span
                                                class="fw-bold @if ($trx->trx_type == '+') text--success @else text--danger @endif">
                                                {{ $trx->trx_type }}
                                                {{ showAmount($trx->amount, $trx->commodity_id == 0 ? 2 : 8, currencyFormat: false) }}
                                                {{ $trx->commodity_id == 0 ? __(gs()->cur_text) : $trx->commodity->unit }}
                                            </span>
                                        </td>
                                        <td class="budget">
                                            {{ showAmount($trx->post_balance, $trx->commodity_id == 0 ? 2 : 8, currencyFormat: false) }}
                                            {{ $trx->commodity_id == 0 ? __(gs()->cur_text) : $trx->commodity->unit }}
                                        </td>
                                        <td>{{ __($trx->details) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    {{ paginateLinks($transactions) }}
                @else
                    @include($activeTemplate . 'partials.empty', ['data' => 'No transaction found'])
                @endif
            </div>
        </div>
    </div>

@endsection

@push('script')
    <script>
        "use strict";
        (function($) {

            $('.select2').select2();

            $('.showFilterBtn').on('click', function() {
                $('.responsive-filter-card').slideToggle();
            });
        })(jQuery);
    </script>
@endpush
