<?php
    $howTradeContent = getContent('how_trade.content', true);
    $howTradeElement = getContent('how_trade.element', orderById: true);
?>

<div class="how-work-section py-110">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-7">
                <div class="section-heading">
                    <h2 class="section-heading__title" data-s-break="-1"><?php echo e(__(@$howTradeContent->data_values->heading)); ?>

                    </h2>
                    <p class="section-heading__desc"> <?php echo e(__(@$howTradeContent->data_values->subheading)); ?></p>
                </div>
            </div>
        </div>
        <div class="row justify-content-center">
            <div class="col-lg-12">
                <div class="how-work">
                    <?php $__currentLoopData = $howTradeElement; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="how-work__item active">
                            <span class="how-work__thumb">
                                <img src="<?php echo e(frontendImage('how_trade', @$element->data_values->image, '105x105')); ?>"
                                    alt="<?php echo app('translator')->get('Image'); ?>">
                            </span>
                            <div class="how-work__content">
                                <span class="how-work__number"><?php echo e($loop->iteration); ?></span>
                                <h5 class="how-work__title"> <?php echo e(__(@$element->data_values->title)); ?> </h5>
                                <p class="how-work__desc">
                                    <?php echo e(__(@$element->data_values->subtitle)); ?>

                                </p>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/cryptowonder/domains/trade.cryptowonder.xyz/public_html/core/resources/views/templates/basic/sections/how_trade.blade.php ENDPATH**/ ?>