<?php
    $bannerContent = getContent('banner.content', true);
?>
<section class="banner-section bg-img"
    data-background-image="<?php echo e(frontendImage('banner', @$bannerContent->data_values->image, '1669x1001')); ?>">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-9">
                <div class="banner-content">
                    <h1 class="banner-content__title" data-s-break="-2"><?php echo e(__(@$bannerContent->data_values->heading)); ?>

                    </h1>
                    <p class="banner-content__desc">
                        <?php echo e(__(@$bannerContent->data_values->subheading)); ?>

                    </p>
                    <div class="trader-type">
                        <div class="item">
                            <div class="thumb">
                                <img src="<?php echo e(frontendImage('banner', @$bannerContent->data_values->left_image, '29x51')); ?>"
                                    alt="<?php echo app('translator')->get('Left banner Image'); ?>">
                            </div>
                            <div class="content">
                                <span class="text"> <?php echo e(__(@$bannerContent->data_values->left_title)); ?> </span>
                                <h4 class="title"> <?php echo e(__(@$bannerContent->data_values->left_subtitle)); ?> </h4>
                            </div>
                        </div>
                        <div class="item">
                            <div class="thumb">
                                <img src="<?php echo e(frontendImage('banner', @$bannerContent->data_values->right_image, '70x69')); ?>"
                                    alt="<?php echo app('translator')->get('Right banner Image'); ?>">
                            </div>
                            <div class="content">
                                <span class="text"> <?php echo e(__(@$bannerContent->data_values->right_title)); ?> </span>
                                <h4 class="title"> <?php echo e(__(@$bannerContent->data_values->right_subtitle)); ?> </h4>
                            </div>
                        </div>
                    </div>
                    <div class="banner-content__button flex-center">
                        <a href="<?php echo e(@$bannerContent->data_values->left_button_link); ?>" class="btn btn--base btn--lg">
                            <?php echo e(__(@$bannerContent->data_values->left_button_text)); ?>

                            <span class="icon">
                                <i class="fa-solid fa-arrow-trend-up"></i>
                            </span>
                        </a>
                        <a href="<?php echo e(@$bannerContent->data_values->right_button_link); ?>"
                            class="btn btn-outline--base btn--lg"><?php echo e(__(@$bannerContent->data_values->right_button_text)); ?>

                            <span class="icon"><i class="fa-solid fa-arrow-trend-up"></i></span>
                        </a>
                    </div>

                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH /home/cryptowonder/domains/trade.cryptowonder.xyz/public_html/core/resources/views/templates/basic/sections/banner.blade.php ENDPATH**/ ?>