<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th> <?php echo app('translator')->get('Commodity'); ?> </th>
                                    <th> <?php echo app('translator')->get('User'); ?> </th>
                                    <th> <?php echo app('translator')->get('Type'); ?> </th>
                                    <th> <?php echo app('translator')->get('Quantity'); ?></th>
                                    <th> <?php echo app('translator')->get('Unit Price'); ?></th>
                                    <th> <?php echo app('translator')->get('Total Price'); ?></th>
                                    <th><?php echo app('translator')->get('Date'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $trades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <div class="user">
                                                <div class="thumb">
                                                    <img src="<?php echo e(getImage(getFilePath('commodityImage') . '/' . @$trade->commodity->image, getFileSize('commodityImage'))); ?>"
                                                        class="plugin_bg">
                                                </div>
                                                <span class="name"><?php echo e(__(@$trade->commodity->name)); ?></span>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="fw-bold"><?php echo e($trade->user->fullname); ?></span>
                                            <br>
                                            <span class="small">
                                                <a
                                                    href="<?php echo e(route('admin.users.detail', $trade->user_id)); ?>"><span>@</span><?php echo e(@$trade->user->username); ?></a>
                                            </span>
                                        </td>
                                        <td>
                                            <?php if($trade->type == Status::TRADE_TYPE_BUY): ?>
                                                <span class="text--success"><?php echo app('translator')->get('Buy'); ?></span>
                                            <?php else: ?>
                                                <span class="text--danger"><?php echo app('translator')->get('Sell'); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php echo e(showAmount($trade->quantity, 8, currencyFormat:false)); ?> <?php echo e(__($trade->commodity->unit)); ?>

                                        </td>
                                        <td>
                                            <div><?php echo e(showAmount($trade->price)); ?>/<?php echo e(__($trade->commodity->unit)); ?></div>
                                        </td>
                                        <td><?php echo e(showAmount($trade->total_cost)); ?></td>
                                        <td>
                                            <div>
                                                <?php echo e(showDateTime($trade->created_at)); ?> <br>
                                                <?php echo e(diffForHumans($trade->created_at)); ?>

                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>

                            </tbody>
                        </table>
                    </div>
                </div>
                <?php if($trades->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($trades)); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <?php if (isset($component)) { $__componentOriginale48b4598ffc2f41a085f001458a956d1 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale48b4598ffc2f41a085f001458a956d1 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.search-form','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('search-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $attributes = $__attributesOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__attributesOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $component = $__componentOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__componentOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/cryptowonder/domains/trade.cryptowonder.xyz/public_html/core/resources/views/admin/trade/index.blade.php ENDPATH**/ ?>