<?php
    $pages = App\Models\Page::where('tempname', $activeTemplate)
        ->where('is_default', Status::NO)
        ->get();
    $language = App\Models\Language::all();
    $selectedLang = $language->where('code', session('lang'))->first();
?>

<header class="header header-style-two" id="header">
    <div class="container">
        <nav class="navbar navbar-expand-lg navbar-light">
            <a class="navbar-brand logo" href="<?php echo e(route('home')); ?>"><img src="<?php echo e(siteLogo()); ?>" alt="<?php echo app('translator')->get('Logo'); ?>"></a>
            <button class="navbar-toggler header-button" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent"
                aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span id="hiddenNav"><i class="las la-bars"></i></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav nav-menu  align-items-lg-center">
                    <li class="nav-item d-block d-lg-none mt-3">
                        <div class="top-button d-flex flex-wrap justify-content-between align-items-center">
                            <ul class="login-registration-list d-flex flex-wrap align-items-center">
                                <?php if(auth()->guard()->guest()): ?>
                                    <li class="login-registration-list__item">
                                        <a href="<?php echo e(route('user.login')); ?>" class="login-registration-list__link login"><?php echo app('translator')->get('Login'); ?></a>
                                    </li>
                                    <li class="login-registration-list__item">
                                        <a href="<?php echo e(route('user.register')); ?>" class="login-registration-list__link register"><?php echo app('translator')->get('Sign Up'); ?></a>
                                    </li>
                                <?php else: ?>
                                    <li class="login-registration-list__item">
                                        <a href="<?php echo e(route('user.home')); ?>" class="login-registration-list__link register"><?php echo app('translator')->get('Dashboard'); ?></a>
                                    </li>
                                    <?php endif; ?>
                                </ul>
                                <?php if(gs()->multi_language): ?>
                                    <div class="custom--dropdown">
                                        <div class="custom--dropdown__selected dropdown-list__item">
                                            <div class="thumb">
                                                <img src="<?php echo e(getImage(getFilePath('language') . '/' . @$selectedLang->image, getFileSize('language'))); ?>"
                                                    alt="<?php echo app('translator')->get('img'); ?>">
                                            </div>
                                            <span class="text"> <?php echo e(@$selectedLang->name); ?> </span>
                                        </div>
                                        <ul class="dropdown-list">
                                            <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li class="dropdown-list__item " data-value="<?php echo e(@$lang->code); ?>">
                                                    <a href="<?php echo e(route('lang', $lang->code)); ?>" class="thumb">
                                                        <img src="<?php echo e(getImage(getFilePath('language') . '/' . @$lang->image, getFileSize('language'))); ?>"
                                                            alt="<?php echo app('translator')->get('image'); ?>">
                                                    </a>
                                                    <span class="text"> <?php echo e(@$lang->name); ?> </span>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </li>
                        <li class="nav-item has-mega-menu">
                            <a class="nav-link" href="javascript:void(0)"><?php echo app('translator')->get('Trade'); ?></a>
                            <div class="mega-menu">
                                <div class="mega-menu__inner">
                                    <ul class="mega-menu-list <?php echo e(gs('future_trade') ? 'list-grid' : ''); ?>">
                                        <?php if(auth()->guard()->check()): ?>
                                            <li class="mega-menu-list__item mega-item-bg1">
                                                <a href="<?php echo e(route('user.trade.index')); ?>" class="mega-menu-list__link">
                                                    <div class="mega-menu-list__content">
                                                        <span class="mega-menu-list__title"><?php echo app('translator')->get('SPOT'); ?></span>
                                                        <p class="mega-menu-list__desc"><?php echo app('translator')->get('Trade smartly with necessary Spot market tools.'); ?></p>
                                                    </div>
                                                    <span class="mega-menu-list__icon">
                                                        <img class="fit-image" src="<?php echo e(getImage('assets/images/extra_images/bar-chart.png', null)); ?>">
                                                    </span>
                                                </a>
                                            </li>
                                        <?php else: ?>
                                            <li class="mega-menu-list__item mega-item-bg1">
                                                <a href="<?php echo e(route('user.login')); ?>" class="mega-menu-list__link">
                                                    <div class="mega-menu-list__content">
                                                        <span class="mega-menu-list__title"><?php echo app('translator')->get('SPOT'); ?></span>
                                                        <p class="mega-menu-list__desc"><?php echo app('translator')->get('Trade smartly with necessary Spot market tools.'); ?></p>
                                                    </div>
                                                    <span class="mega-menu-list__icon">
                                                        <img class="fit-image" src="<?php echo e(getImage('assets/images/extra_images/bar-chart.png', null)); ?>">
                                                    </span>
                                                </a>
                                            </li>
                                        <?php endif; ?>
                                        <?php if(Route::has('p2p')): ?>
                                            <li class="mega-menu-list__item mega-item-bg2">
                                                <a href="<?php echo e(route('p2p')); ?>" class="mega-menu-list__link">
                                                    <div class="mega-menu-list__content">
                                                        <span class="mega-menu-list__title"><?php echo app('translator')->get('P2P'); ?></span>
                                                        <p class="mega-menu-list__desc"><?php echo app('translator')->get('Buy & sell crypto with your preferred payment methods.'); ?></p>
                                                    </div>
                                                    <span class="mega-menu-list__icon">
                                                        <img class="fit-image" src="<?php echo e(getImage('assets/images/extra_images/p2p.png', null)); ?>">
                                                    </span>
                                                </a>
                                            </li>
                                        <?php endif; ?>
                                        <li class="mega-menu-list__item mega-item-bg3">
                                            <a href="<?php echo e(route('binary')); ?>" class="mega-menu-list__link">
                                                <div class="mega-menu-list__content">
                                                    <span class="mega-menu-list__title"><?php echo app('translator')->get('Binary'); ?></span>
                                                    <p class="mega-menu-list__desc"><?php echo app('translator')->get('Binary trading predicts asset price changes over time.'); ?></p>
                                                </div>
                                                <span class="mega-menu-list__icon">
                                                    <img class="fit-image" src="<?php echo e(getImage('assets/images/extra_images/trading.png', null)); ?>">
                                                </span>
                                            </a>
                                        </li>
                                        <?php if(gs('future_trade') && Route::has('future.trade')): ?>
                                            <li class="mega-menu-list__item mega-item-bg4">
                                                <a href="<?php echo e(route('future.trade')); ?>" class="mega-menu-list__link">
                                                    <div class="mega-menu-list__content">
                                                        <span class="mega-menu-list__title"><?php echo app('translator')->get('Future'); ?></span>
                                                        <p class="mega-menu-list__desc"><?php echo app('translator')->get('Futures trading is predicting if prices go up or down.'); ?></p>
                                                    </div>
                                                    <span class="mega-menu-list__icon">
                                                        <img class="fit-image" src="<?php echo e(getImage('assets/images/extra_images/future.png')); ?>">
                                                    </span>
                                                </a>
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </div>
                        </li>
                        <li class="nav-item <?php echo e(menuActive('home')); ?>">
                            <a class="nav-link" aria-current="page" href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('Home'); ?></a>
                        </li>
                        <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="nav-item <?php echo e(menuActive('pages', null, $data->slug)); ?>">
                                <a class="nav-link" href="<?php echo e(route('pages', [$data->slug])); ?>"> <?php echo e(__($data->name)); ?> </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <li class="nav-item <?php echo e(menuActive('blog')); ?>">
                            <a class="nav-link" href="<?php echo e(route('blog')); ?>"><?php echo app('translator')->get('Blog'); ?></a>
                        </li>
                        <li class="nav-item <?php echo e(menuActive('contact')); ?>">
                            <a class="nav-link" href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('Contact'); ?></a>
                        </li>
                    </ul>
                    <div class="nav-item d-lg-block d-none ms-auto">
                        <div class="top-button d-flex flex-wrap justify-content-between align-items-center">
                            <ul class="login-registration-list d-flex flex-wrap align-items-center">
                                <?php if(auth()->guard()->guest()): ?>
                                    <li class="login-registration-list__item">
                                        <a href="<?php echo e(route('user.login')); ?>" class="login-registration-list__link login"><?php echo app('translator')->get('Login'); ?></a>
                                    </li>
                                    <li class="login-registration-list__item">
                                        <a href="<?php echo e(route('user.register')); ?>" class="login-registration-list__link register"><?php echo app('translator')->get('Sign Up'); ?></a>
                                    </li>
                                <?php else: ?>
                                    <li class="login-registration-list__item">
                                        <a href="<?php echo e(route('user.home')); ?>" class="login-registration-list__link register"><?php echo app('translator')->get('Dashboard'); ?></a>
                                    </li>
                                    <?php endif; ?>
                                </ul>

                                <?php if(gs()->multi_language): ?>
                                    <div class="custom--dropdown">
                                        <div class="custom--dropdown__selected dropdown-list__item">
                                            <div class="thumb">
                                                <img src="<?php echo e(getImage(getFilePath('language') . '/' . @$selectedLang->image, getFileSize('language'))); ?>"
                                                    alt="<?php echo app('translator')->get('img'); ?>">
                                            </div>
                                            <span class="text"> <?php echo e(@$selectedLang->name); ?> </span>
                                        </div>
                                        <ul class="dropdown-list">
                                            <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li class="dropdown-list__item " data-value="<?php echo e(@$lang->code); ?>">
                                                    <a href="<?php echo e(route('lang', $lang->code)); ?>" class="dropdown-list__link">
                                                        <span class="thumb">
                                                            <img src="<?php echo e(getImage(getFilePath('language') . '/' . @$lang->image, getFileSize('language'))); ?>"
                                                                alt="<?php echo app('translator')->get('image'); ?>">
                                                        </span>
                                                        <span class="text"> <?php echo e(@$lang->name); ?> </span>
                                                    </a>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </nav>
            </div>
        </header>
<?php /**PATH /home/cryptowonder/domains/trade.cryptowonder.xyz/public_html/core/resources/views/templates/basic/partials/header.blade.php ENDPATH**/ ?>