<?php $__env->startSection('content'); ?>
    <div class="dashboard-body">
        <div class="row justify-content-center gy-4">
            <div class=" d-flex  flex-wrap align-items-center justify-content-between gap-2 all-asset">
                <div class="pagetitle">
                    <h4 class="mb-0"><?php echo e(__($pageTitle)); ?></h4>
                </div>
                <form>
                    <div class="input-group">
                        <input type="search" name="search" class="form-control form--control" placeholder="<?php echo app('translator')->get('Commodity Name'); ?>"
                            value="<?php echo e(request()->search ?? ''); ?>">
                        <button class="btn btn--base input-group-text"><i class="fa fa-search"></i></button>
                    </div>
                </form>
            </div>
            <div class="col-xl-12">
                <?php if(!$trades->isEmpty()): ?>
                    <div class="trade-table">
                        <table class="table table--responsive--xxl">
                            <thead>
                                <tr>
                                    <th> <?php echo app('translator')->get('Commodity'); ?> </th>
                                    <th> <?php echo app('translator')->get('Type'); ?> </th>
                                    <th> <?php echo app('translator')->get('Quantity'); ?></th>
                                    <th> <?php echo app('translator')->get('Unit Price'); ?></th>
                                    <th> <?php echo app('translator')->get('Total Price'); ?></th>
                                    <th><?php echo app('translator')->get('Date'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $trades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <div class="commodities flex-align">
                                                <div class="commodities__thumb">
                                                    <img src="<?php echo e(getImage(getFilePath('commodityImage') . '/' . @$trade->commodity->image, getFileSize('commodityImage'))); ?>"
                                                        class="fit-image" alt="<?php echo app('translator')->get('Commodity Image'); ?>">
                                                </div>
                                                <div class="commodities__content">
                                                    <h6 class="commodities__name"><?php echo e(__(@$trade->commodity->name)); ?></h6>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <?php if($trade->type == Status::TRADE_TYPE_BUY): ?>
                                                <span class="text--success"><?php echo app('translator')->get('Buy'); ?></span>
                                            <?php else: ?>
                                                <span class="text--danger"><?php echo app('translator')->get('Sell'); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php echo e(showAmount($trade->quantity, 8, currencyFormat: false)); ?>

                                            <?php echo e(__($trade->commodity->unit)); ?>

                                        </td>
                                        <td>
                                            <div>
                                                <?php echo e(gs()->cur_sym); ?><?php echo e(showAmount($trade->price, currencyFormat: false)); ?>/<?php echo e(__($trade->commodity->unit)); ?>

                                            </div>
                                        </td>
                                        <td><?php echo e(showAmount($trade->total_cost)); ?></td>
                                        <td>
                                            <div>
                                                <?php echo e(showDateTime($trade->created_at)); ?> <br>
                                                <?php echo e(diffForHumans($trade->created_at)); ?>

                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <?php echo e(paginateLinks($trades)); ?>

                <?php else: ?>
                    <?php echo $__env->make($activeTemplate . 'partials.empty', ['data' => 'No trading found'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/cryptowonder/domains/trade.cryptowonder.xyz/public_html/core/resources/views/templates/basic/user/trade/history.blade.php ENDPATH**/ ?>