<?php
    $aboutContent = getContent('about.content', true);
    $aboutElement = getContent('about.element', orderById: true);
?>

<div class="why-choose-section py-110 section-bg">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-7">
                <div class="section-heading">
                    <h2 class="section-heading__title" data-s-break="-1"> <?php echo e(__(@$aboutContent->data_values->heading)); ?>

                    </h2>
                    <p class="section-heading__desc"> <?php echo e(__(@$aboutContent->data_values->subheading)); ?></p>
                </div>
            </div>
        </div>
        <div class="row gy-4 ">
            <div class="col-xl-6 col-lg-5 pe-lg-5">
                <div class="why-choose__thumb">
                    <img src="<?php echo e(frontendImage('about', @$aboutContent->data_values->image, '600x452')); ?>"
                        alt="<?php echo app('translator')->get('About Image'); ?>">
                    <a href="<?php echo e(@$aboutContent->data_values->video_link); ?>" class="play-button">
                        <span class="icon"><i class="fas fa-play"></i></span>
                    </a>
                </div>
            </div>
            <div class="col-xl-6 col-lg-7 ps-lg-2">
                <div class="why-choose__right">
                    <div class="row gy-4 ">
                        <?php $__currentLoopData = $aboutElement; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-sm-6 col-xsm-6">
                                <div class="choose-item">
                                    <div class="choose-item__thumb">
                                        <img src="<?php echo e(frontendImage('about', @$element->data_values->image, '600x452')); ?>"
                                            alt="<?php echo app('translator')->get('About Thumb'); ?>">
                                    </div>
                                    <div class="choose-item__content">
                                        <h5 class="choose-item__title"> <?php echo e(__(@$element->data_values->title)); ?></h5>
                                        <p class="choose-item__desc"><?php echo e(__(@$element->data_values->subtitle)); ?></p>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue . 'css/magnific-popup.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset($activeTemplateTrue . 'js/magnific-popup.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        var videoItem = $(".play-button");
        (function($) {

            if (videoItem) {
                videoItem.magnificPopup({
                    type: "iframe",
                });
            };
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/cryptowonder/domains/trade.cryptowonder.xyz/public_html/core/resources/views/templates/basic/sections/about.blade.php ENDPATH**/ ?>