<?php $__env->startSection('panel'); ?>
    <?php
        $credentials = gs()->socialite_credentials;
        $registerContent = @getContent('register.content', true)->data_values;
        $policyPages = getContent('policy_pages.element', false, null, true);
    ?>
    <?php if(gs('registration')): ?>
        <section class="account ">
            <div class="account-inner">
                <div class="account__left">
                    <div class="account-thumb">
                        <img src="<?php echo e(frontendImage('register', @$registerContent->image, '865x920')); ?>"
                            alt="<?php echo app('translator')->get('image'); ?>" />
                    </div>
                </div>
                <div class="account__right">
                    <div class="account__content">
                        <div
                            class="account-header-wrapper d-flex align-items-center justify-content-between gap-2 flex-wrap">
                            <a class="navbar-brand logo" href="<?php echo e(route('home')); ?>"><img src="<?php echo e(siteLogo()); ?>"
                                    alt="<?php echo app('translator')->get('logo'); ?>"></a>
                            <div class="top-button d-flex justify-content-between align-items-center">
                                <ul class="login-registration-list d-flex flex-wrap align-items-center">
                                    <li class="login-registration-list__item"> <?php echo app('translator')->get('Already have an account?'); ?></li>
                                    <li class="login-registration-list__item">
                                        <a href="<?php echo e(route('user.login')); ?>" class="login-registration-list__link register">
                                            <?php echo app('translator')->get('Sign In'); ?> <i class="fas fa-angle-right"></i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="account-form">
                            <div class="account-form__wrapper">
                                <h3 class="account-form__title mb-2"><?php echo e(__(@$registerContent->heading)); ?></h3>
                                <p class="account-form__desc"><?php echo e(__(@$registerContent->subheading)); ?></p>
                            </div>
                            <form action="<?php echo e(route('user.register')); ?>" method="POST"
                                class="verify-gcaptcha disableSubmission">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <?php if(session()->get('reference') != null): ?>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="referenceBy" class="form-label"><?php echo app('translator')->get('Reference by'); ?></label>
                                                <input type="text" name="referBy" id="referenceBy"
                                                    class="form--control form-three"
                                                    value="<?php echo e(session()->get('reference')); ?>" readonly>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <div class="col-sm-6 form-group">
                                        <label class="form--label label-two"><?php echo app('translator')->get('First Name'); ?></label>
                                        <input type="text" class="form--control form-three" id="firstname"
                                            name="firstname" value="<?php echo e(old('firstname')); ?>" required>
                                    </div>
                                    <div class="col-sm-6 form-group">
                                        <label class="form--label label-two"><?php echo app('translator')->get('Last Name'); ?></label>
                                        <input type="text" class="form--control form-three" id="lastname"
                                            name="lastname" value="<?php echo e(old('lastname')); ?>" required>
                                    </div>
                                    <div class="col-sm-12 form-group">
                                        <label class="form--label label-two"><?php echo app('translator')->get('Email'); ?></label>
                                        <input type="text" class="form--control form-three checkUser" id="email"
                                            name="email" value="<?php echo e(old('email')); ?>" required>
                                    </div>

                                    <div class="col-sm-6 form-group">
                                        <div class="d-flex flex-wrap justify-content-between">
                                            <label for="password" class="form--label label-two"><?php echo app('translator')->get('Password'); ?></label>
                                        </div>
                                        <div class="position-relative">
                                            <input id="password" type="password"
                                                class="form-control form--control  form-three <?php if(gs('secure_password')): ?> secure-password <?php endif; ?> "
                                                name="password" required>
                                            <span class="password-show-hide fas toggle-password fa-eye-slash"
                                                id="#password"></span>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 form-group">
                                        <label for="password_confirmation" class="form--label label-two"> <?php echo app('translator')->get('Confirm Password'); ?>
                                        </label>
                                        <div class="position-relative">
                                            <input id="password_confirmation" type="password"
                                                class="form-control form--control form-three" name="password_confirmation"
                                                required>
                                            <span class="password-show-hide fas toggle-password fa-eye-slash"
                                                id="#password_confirmation">
                                            </span>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <?php if (isset($component)) { $__componentOriginalff0a9fdc5428085522b49c68070c11d6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalff0a9fdc5428085522b49c68070c11d6 = $attributes; } ?>
<?php $component = App\View\Components\Captcha::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('captcha'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Captcha::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $attributes = $__attributesOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $component = $__componentOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__componentOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
                                    </div>

                                    <?php if(gs('agree')): ?>
                                        <div class="col-sm-12 form-group">
                                            <div class="form--check">
                                                <input class="form-check-input" type="checkbox" <?php if(old('agree')): echo 'checked'; endif; ?>
                                                    name="agree" required id="agree">
                                                <div class="form-check-label">
                                                    <label for="agree"><?php echo app('translator')->get('I agree with'); ?></label>
                                                    <span>
                                                        <?php $__currentLoopData = $policyPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <a
                                                                href="<?php echo e(route('policy.pages', $policy->slug)); ?>"><?php echo e(__(@$policy->data_values->title)); ?></a>
                                                            <?php if(!$loop->last): ?>
                                                                ,
                                                            <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                    <div class="mb-3 mb-md-5 col-sm-12">
                                        <button type="submit" id="recaptcha" class="btn btn--base w-100">
                                            <?php echo app('translator')->get('Sign Up'); ?> </button>
                                    </div>

                                    <div class="col-12">
                                        <?php echo $__env->make($activeTemplate . 'partials.social_login', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                                    </div>

                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php else: ?>
        <?php echo $__env->make($activeTemplate . 'partials.registration_disabled', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <?php endif; ?>

    <div class="modal custom--modal" id="existModalCenter" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="existModalLongTitle"><?php echo app('translator')->get('You are with us'); ?></h5>
                    <span role="button" class="close" data-bs-dismiss="modal">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <h6 class="text-center"><?php echo app('translator')->get('You already have an account please Login '); ?></h6>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn--dark btn--sm"
                        data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                    <a href="<?php echo e(route('user.login')); ?>" class="btn btn--base btn--sm"><?php echo app('translator')->get('Login'); ?></a>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .register-disable {
            height: 100vh;
            width: 100%;
            background-color: #fff;
            color: black;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .register-disable-image {
            max-width: 300px;
            width: 100%;
            margin: 0 auto 32px;
        }

        .register-disable-title {
            color: rgb(0 0 0 / 80%);
            font-size: 42px;
            margin-bottom: 18px;
            text-align: center
        }

        .register-disable-icon {
            font-size: 16px;
            background: rgb(255, 15, 15, .07);
            color: rgb(255, 15, 15, .8);
            border-radius: 3px;
            padding: 6px;
            margin-right: 4px;
        }

        .register-disable-desc {
            color: rgb(0 0 0 / 50%);
            font-size: 18px;
            max-width: 565px;
            width: 100%;
            margin: 0 auto 32px;
            text-align: center;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php if(gs('secure_password')): ?>
    <?php $__env->startPush('script-lib'); ?>
        <script src="<?php echo e(asset('assets/global/js/secure_password.js')); ?>"></script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        (function($) {

            $('.checkUser').on('focusout', function(e) {
                var url = '<?php echo e(route('user.checkUser')); ?>';
                var value = $(this).val();
                var token = '<?php echo e(csrf_token()); ?>';

                var data = {
                    email: value,
                    _token: token
                }

                $.post(url, data, function(response) {
                    if (response.data != false) {
                        $('#existModalCenter').modal('show');
                    }
                });
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/cryptowonder/domains/trade.cryptowonder.xyz/public_html/core/resources/views/templates/basic/user/auth/register.blade.php ENDPATH**/ ?>