<?php
    $footerContent = getContent('footer.content', true);
    $footerElement = getContent('social_icon.element', orderById: true);
    $pages         = App\Models\Page::where('tempname', $activeTemplate)
        ->where('is_default', Status::NO)
        ->get();
    $policyPages    = getContent('policy_pages.element', false, null, true);
    $contactContent = getContent('contact_us.content', true);
?>

<footer class="footer-area section-bg">
    <div class="footer-wrapper">
        <div class="container">
            <div class="footer-item-wrapper">
                <div class="footer-item">
                    <div class="footer-item__logo">
                        <a href="<?php echo e(route('home')); ?>"> <img src="<?php echo e(siteLogo()); ?>" alt="<?php echo app('translator')->get('Logo'); ?>"></a>
                    </div>
                    <p class="footer-item__desc"><?php echo e(__(@$footerContent->data_values->short_details)); ?></p>
                    <ul class="social-list">
                        <?php $__currentLoopData = $footerElement; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="social-list__item">
                                <a href="<?php echo e(@$element->data_values->url); ?>" target="blank" class="social-list__link flex-center">
                                    <?php echo @$element->data_values->icon; ?>
                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <div class="footer-item">
                    <h6 class="footer-item__title"><?php echo app('translator')->get('Quick Links'); ?> </h6>
                    <ul class="footer-menu">
                        <li class="footer-menu__item"><a href="<?php echo e(route('home')); ?>" class="footer-menu__link"> <?php echo app('translator')->get('Home'); ?> </a></li>
                        <li class="footer-menu__item"><a href="<?php echo e(route('blog')); ?>" class="footer-menu__link"> <?php echo app('translator')->get('Blog'); ?> </a></li>
                        <li class="footer-menu__item"><a href="<?php echo e(route('contact')); ?>" class="footer-menu__link"> <?php echo app('translator')->get('Contact'); ?> </a></li>
                    </ul>
                </div>
                <div class="footer-item">
                    <h6 class="footer-item__title"><?php echo app('translator')->get('Policy Pages'); ?></h6>
                    <ul class="footer-menu">
                        <?php $__currentLoopData = $policyPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="footer-menu__item">
                                <a href="<?php echo e(route('policy.pages', $policy->slug)); ?>"
                                    class="footer-menu__link"><?php echo e(__($policy->data_values->title)); ?></a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <div class="footer-item">
                    <h6 class="footer-item__title"><?php echo app('translator')->get('Contact Us'); ?></h6>
                    <ul class="footer-menu">
                        <li class="footer-menu__item"><a href="mailto:<?php echo e(@$contactContent->data_values->email); ?>" class="footer-menu__link"><?php echo e(@$contactContent->data_values->email); ?></a></li>
                        <li class="footer-menu__item"><a href="tel:<?php echo e(str_replace(" ","",@$contactContent->data_values->mobile_number)); ?>" class="footer-menu__link"><?php echo e(@$contactContent->data_values->mobile_number); ?></a></li>
                        <li class="footer-menu__item"><?php echo e(@$contactContent->data_values->address); ?></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="bottom-footer">
        <div class="container">
            <div class="bottom-footer__wrapper">
                <div class="row justify-content-center">
                    <div class="col-md-6 text-center">
                        <p class="bottom-footer-text">
                            ©<?php echo e(date('Y')); ?> <a href="<?php echo e(route('home')); ?>"><?php echo e(__(gs()->site_name)); ?>.</a>
                            <?php echo app('translator')->get('All Right Reserved'); ?>.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>
<?php /**PATH /home/cryptowonder/domains/trade.cryptowonder.xyz/public_html/core/resources/views/templates/basic/partials/footer.blade.php ENDPATH**/ ?>