
<?php $__env->startSection('content'); ?>
    <div class="row justify-content-between gy-3 align-items-center">
        <div class="col-12">
            <div class="dashboard-header-menu justify-content-between">
                <div class="div">
                    <a href="<?php echo e(route('user.binary.trade.all')); ?>"
                       class="dashboard-header-menu__link   <?php echo e(menuActive('user.binary.trade.all')); ?>"><?php echo app('translator')->get('All'); ?></a>
                    <a href="<?php echo e(route('user.binary.trade.win')); ?>"
                       class="dashboard-header-menu__link   <?php echo e(menuActive('user.binary.trade.win')); ?>"><?php echo app('translator')->get('Win'); ?></a>
                    <a href="<?php echo e(route('user.binary.trade.lose')); ?>"
                       class="dashboard-header-menu__link   <?php echo e(menuActive('user.binary.trade.lose')); ?>"><?php echo app('translator')->get('Lose'); ?></a>
                    <a href="<?php echo e(route('user.binary.trade.refund')); ?>"
                       class="dashboard-header-menu__link   <?php echo e(menuActive('user.binary.trade.refund')); ?>"><?php echo app('translator')->get('Refund'); ?></a>
                </div>
                <form class="d-flex gap-2 flex-wrap">
                    <div class="flex-fill">
                        <div class="input-group">
                            <input type="text" name="search" class="form-control form--control" value="<?php echo e(request()->search); ?>" placeholder="<?php echo app('translator')->get('Pair,coin,trx...'); ?>">
                            <button type="submit" class="input-group-text bg--primary text-white"><i class="las la-search"></i></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <div class="col-lg-12">
            <div class="table-wrapper">
                <table class="table table--responsive--lg">
                    <thead>
                        <tr>
                            <th><?php echo app('translator')->get('TRX | Coin Pair'); ?></th>
                            <th><?php echo app('translator')->get('Trade Date'); ?></th>
                            <th><?php echo app('translator')->get('Invest'); ?></th>
                            <th><?php echo app('translator')->get('Duration'); ?></th>
                            <th><?php echo app('translator')->get('Direction'); ?></th>
                            <th><?php echo app('translator')->get('Win Amount'); ?></th>
                            <th><?php echo app('translator')->get('Status'); ?></th>
                            <th><?php echo app('translator')->get('Win Status'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $trades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <div>
                                        <?php echo e($trade->trx); ?>

                                        <br>
                                        <?php echo e(@$trade->coinPair->symbol); ?>

                                    </div>
                                </td>
                                <td><?php echo e(showDateTime($trade->created_at)); ?></td>
                                <td> <?php echo e(showAmount($trade->amount, currencyFormat: false)); ?> <?php echo e(__(@$trade->coinPair->coin->symbol)); ?></td>
                                <td><?php echo convertToMinutesSeconds($trade->duration)  ?></td>
                                <td><?php echo e(__($trade->direction)); ?></td>
                                <td>
                                    <?php if($trade->win_status == Status::BINARY_TRADE_WIN): ?>
                                        <span class="text--success"><?php echo e(showAmount($trade->win_amount, currencyFormat: false)); ?> <?php echo e(__(@$trade->coinPair->coin->symbol)); ?></span>
                                    <?php elseif($trade->win_status == Status::BINARY_TRADE_LOSE): ?>
                                        <span class="text--danger"><?php echo e(showAmount($trade->win_amount, currencyFormat: false)); ?> <?php echo e(__(@$trade->coinPair->coin->symbol)); ?></span>
                                    <?php else: ?>
                                        <?php echo e(showAmount($trade->win_amount, currencyFormat: false)); ?> <?php echo e(__(@$trade->coinPair->coin->symbol)); ?>

                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php
                                        echo $trade->tradeStatusBadge;
                                    ?>
                                </td>
                                <td>
                                    <?php
                                        echo $trade->winStatusBadge;
                                    ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <?php echo userTableEmptyMessage('trade') ?>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
                <?php echo e(paginateLinks($trades)); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('topContent'); ?>
    <h4 class="mb-4"><?php echo e(__($pageTitle)); ?></h4>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/cryptowonder/domains/trade.cryptowonder.xyz/public_html/core/resources/views/templates/basic/user/binary/trade_history.blade.php ENDPATH**/ ?>