<?php $__env->startSection('content'); ?>
    <div class="dashboard-body">
        <div class="row justify-content-center">
            <div class="col-xl-8 col-lg-10">
                <div class="d-flex flex-wrap justify-content-between gap-2 mb-4 align-items-center all-asset">
                    <h4 class="trade-form__title mb-0"> <?php echo app('translator')->get('New Trade'); ?> </h4>
                    <div>
                        <a href="<?php echo e(route('user.trade.history')); ?>" class="btn btn-outline--base btn--sm">
                            <i class="las la-list"></i> <?php echo app('translator')->get('Trade History'); ?>
                        </a>
                    </div>
                </div>
                <div class="trade-form">
                    <form action="<?php echo e(route('user.trade.store')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-xl-6 col-sm-6 form-group">
                                <label class="form--label"> <?php echo app('translator')->get('Commodity Name'); ?> </label>
                                <select class="custom-select country-select" name="commodity" required>
                                    <option value=""><?php echo app('translator')->get('Select'); ?></option>
                                    <?php $__currentLoopData = $commodities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $commodity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option
                                            data-image="<?php echo e(getImage(getFilePath('commodityImage') . '/' . $commodity->image, getFileSize('commodityImage'))); ?>"
                                            value="<?php echo e($commodity->id); ?>" <?php if(old('commodity') == $commodity->id || request()->query('commodity_id') == $commodity->id): echo 'selected'; endif; ?>
                                            data-commodity="<?php echo e($commodity); ?>">
                                            <?php echo e(__($commodity->name)); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-xl-6 col-sm-6 form-group">
                                <label class="form--label"> <?php echo app('translator')->get('Trade Type'); ?> </label>
                                <select class="custom-select gateway-select form-three" name="type">
                                    <option value="<?php echo e(Status::TRADE_TYPE_BUY); ?>">
                                        <?php echo app('translator')->get('Buy'); ?>
                                    </option>
                                    <option value="<?php echo e(Status::TRADE_TYPE_SELL); ?>">
                                        <?php echo app('translator')->get('Sale'); ?>
                                    </option>
                                </select>
                            </div>
                            <div class="col-xl-6 col-sm-6 form-group">
                                <label class="form--label"> <?php echo app('translator')->get('Amount'); ?> </label>
                                <div class="input-group mb-2">
                                    <input type="number" class="form-control form--control form-three amount"
                                        step="any" name="amount" value="<?php echo e(old('amount')); ?>" id="amount" required>
                                    <span class="input-group-text bg-style currency"><?php echo e(__(gs()->cur_text)); ?></span>
                                </div>
                                <span class="text--base fs-14 avl-balance">
                                    <?php echo app('translator')->get('Available balance is'); ?>: <?php echo e(showAmount(auth()->user()->balance)); ?>

                                </span>
                                <span class="text--base balance-sperator d-none">|</span>
                                <span class="text--base fs-14 d-none commodity-price-wrapper mb-2">
                                    <?php echo app('translator')->get('Price'); ?>: <span class="commodity-price"></span>
                                </span>
                            </div>
                            <div class="col-xl-6 col-sm-6 form-group">
                                <label class="form--label"> <?php echo app('translator')->get('Quantity'); ?> </label>
                                <div class="input-group mb-2">
                                    <input type="number" class="form-control form--control form-three amount"
                                        name="qty" id="qty" step="any">
                                    <span class="input-group-text bg-style unit"></span>
                                </div>
                                <span class="text--base fs-14 d-none commodity-qty-wrapper"><?php echo app('translator')->get('Available quantity is'); ?>: <span
                                        class="commodity-qty"></span></span>
                            </div>
                            <div class="col-12">
                                <button class="btn btn--base w-100">
                                    <?php echo app('translator')->get('Submit'); ?>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue . 'css/custom-select.css')); ?>" />
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(asset($activeTemplateTrue . 'js/custom-select.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";

            $(".country-select").customSelect({
                search: true
            });
            $(".gateway-select").customSelect();

            var commodityPrice, commodityId;
            var tradeType = 1;

            $('select[name=commodity]').on("change", function() {

                if (!$(this).val()) return;

                var resource = $('select[name=commodity] option:selected').data('commodity');
                var unit = resource.unit;

                commodityPrice = parseFloat(resource.price);
                commodityId = resource.id;

                $(".commodity-price").text(`${commodityPrice.toFixed(2)} <?php echo e(__(gs()->cur_text)); ?> / ${unit}`);
                $(".commodity-price-wrapper").removeClass('d-none')
                $('.unit').text(unit);

                balanceSperator();
                getCommodityQty();

            }).change();

            $('select[name=type]').on("change", function() {

                tradeType = $(this).val();
                if (tradeType == 2) {
                    $('.avl-balance').addClass('d-none');
                } else {
                    $('.avl-balance').removeClass('d-none');
                }

                balanceSperator();
                getCommodityQty();
            });

            $('input[name=amount]').on('input', function() {
                if (!commodityPrice) return;
                var amount = parseFloat($(this).val() || 1);
                var quantity = amount / commodityPrice;
                $('input[name=qty]').val(quantity.toFixed(8));
            });

            $('input[name=qty]').on('input', function() {
                if (!commodityPrice) return;
                var quantity = parseFloat($(this).val());
                var amount = quantity * commodityPrice;
                $('input[name=amount]').val(amount.toFixed(2));
            });

            function getCommodityQty() {

                if (!tradeType || tradeType != 2 || !commodityId) {
                    $('.commodity-qty-wrapper').addClass('d-none');
                    return false;
                };

                $.ajax({
                    url: '<?php echo e(route('user.trade.asset.balance')); ?>',
                    method: 'POST',
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        commodity: commodityId
                    },
                    success: function(response) {
                        if (response.success) {
                            $('.commodity-qty').text(response.balance);
                            $('.commodity-qty-wrapper').removeClass('d-none');
                        } else {
                            notify('error', response.message);
                        }
                    }
                });
            }

            function balanceSperator() {
                if (commodityId && tradeType == 1) {
                    $('.balance-sperator').removeClass('d-none');
                } else {
                    $('.balance-sperator').addClass('d-none');
                }
            }

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/cryptowonder/domains/trade.cryptowonder.xyz/public_html/core/resources/views/templates/basic/user/trade/index.blade.php ENDPATH**/ ?>