<?php
    $testimonialContent = getContent('testimonial.content', true);
    $testimonialElement = getContent('testimonial.element', orderById: true);
?>

<section class="testimonials py-110">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-7">
                <div class="section-heading">
                    <h2 class="section-heading__title" data-s-break="1">
                        <?php echo e(__(@$testimonialContent->data_values->heading)); ?></h2>
                    <p class="section-heading__desc"> <?php echo e(__(@$testimonialContent->data_values->subheading)); ?></p>
                </div>
            </div>
        </div>
        <div class="testimonial-slider">
            <?php $__currentLoopData = $testimonialElement; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="testimonails-card">
                    <div class="testimonial-item">
                        <div class="testimonial-item__info">
                            <div class="testimonial-item__thumb">
                                <img src="<?php echo e(frontendImage('testimonial', @$element->data_values->image, '60x60')); ?>"
                                    class="fit-image" alt="<?php echo app('translator')->get('Testimonial Image'); ?>">
                            </div>
                            <div class="testimonial-item__details">
                                <h6 class="testimonial-item__name"> <?php echo e(__(@$element->data_values->name)); ?> </h6>
                                <span class="testimonial-item__designation"> <?php echo e(__(@$element->data_values->title)); ?>

                                </span>
                            </div>
                        </div>
                        <p class="testimonial-item__desc"> <?php echo e(__(@$element->data_values->comment)); ?> </p>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>



<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue . 'css/slick.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset($activeTemplateTrue . 'js/slick.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        (function($) {
            $(".testimonial-slider").slick({
                slidesToShow: 3,
                slidesToScroll: 1,
                autoplay: true,
                autoplaySpeed: 2000,
                speed: 1500,
                dots: true,
                pauseOnHover: true,
                arrows: false,
                prevArrow: '<button type="button" class="slick-prev"><i class="fas fa-long-arrow-alt-left"></i></button>',
                nextArrow: '<button type="button" class="slick-next"><i class="fas fa-long-arrow-alt-right"></i></button>',
                responsive: [{
                        breakpoint: 1199,
                        settings: {
                            arrows: false,
                            slidesToShow: 2,
                            dots: true,
                        },
                    },
                    {
                        breakpoint: 991,
                        settings: {
                            arrows: false,
                            slidesToShow: 2,
                        },
                    },
                    {
                        breakpoint: 464,
                        settings: {
                            arrows: false,
                            slidesToShow: 1,
                        },
                    },
                ],
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/cryptowonder/domains/trade.cryptowonder.xyz/public_html/core/resources/views/templates/basic/sections/testimonial.blade.php ENDPATH**/ ?>