<?php
    $contactContent = getContent('contact_us.content', true);
    $contactElement = getContent('contact_us.element', orderById: true);
?>

<?php $__env->startSection('content'); ?>
    <div class="contact-section py-110">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-7">
                    <div class="section-heading">
                        <h2 class="section-heading__title"> <?php echo e(__(@$contactContent->data_values->heading)); ?></h2>
                        <p class="section-heading__desc"> <?php echo e(__(@$contactContent->data_values->subheading)); ?></p>
                    </div>
                </div>
            </div>
            <div class="row gy-4 justify-content-center">
                <div class="row gy-4 justify-content-center">
                    <div class="col-lg-4 col-sm-6">
                        <div class="contact-item h-100">
                            <div class="contact-item__shape"></div>
                            <span class="contact-item__icon"><i class="las la-envelope"></i></span>
                            <h4 class="contact-item__title"> <?php echo app('translator')->get('Send Us an Email'); ?> </h4>
                            <p class="contact-item__text">
                                <?php echo app('translator')->get('Reach out'); ?>
                                <a href="mailto:<?php echo e(@$contactContent->data_values->email); ?>"
                                    class="contact-item__link"><?php echo e(@$contactContent->data_values->email); ?>

                                </a>
                                <?php echo app('translator')->get("and we'll get back to you in 24 hours"); ?>
                            </p>
                        </div>
                    </div>
                    <div class="col-lg-4 col-sm-6">
                        <div class="contact-item h-100">
                            <div class="contact-item__shape"></div>
                            <span class="contact-item__icon"><i class="las la-phone-volume"></i></span>
                            <h4 class="contact-item__title"> <?php echo app('translator')->get('Give us a call'); ?> </h4>
                            <p class="contact-item__text">
                                <?php echo app('translator')->get('In need of more assistance? Give us a call at'); ?>
                                <a href="tel:<?php echo e(str_replace(' ', '', @$contactContent->data_values->mobile_number)); ?>"
                                    class="contact-item__link"><?php echo e(@$contactContent->data_values->mobile_number); ?>

                                </a>
                            </p>
                        </div>
                    </div>
                    <div class="col-lg-4 col-sm-6">
                        <div class="contact-item h-100">
                            <div class="contact-item__shape"></div>
                            <span class="contact-item__icon"><i class="las la-map-marker-alt"></i></span>
                            <h4 class="contact-item__title"> <?php echo app('translator')->get('We are located at'); ?> </h4>
                            <p class="contact-item__text ">
                                <?php echo app('translator')->get('Feel free to drop by our office at your convenience'); ?> <br>
                                <span class="text--base">
                                    <?php echo e(@$contactContent->data_values->address); ?>

                                </span>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="contact-bottom pt-150">
                <div class="row gy-4 justify-content-center">
                    <div class="col-xl-6 col-lg-5 col-md-8 pe-lg-5 d-none d-md-block">
                        <div class="contact-bottom__thumb">
                            <img src="<?php echo e(frontendImage('contact_us', @$contactContent->data_values->image, '600x705')); ?>"
                                alt="<?php echo app('translator')->get('img'); ?>">
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-7 ">
                        <div class="contact-form">
                            <h2 class="contact-form__title"> <?php echo e(@__($contactContent->data_values->form_heading)); ?> </h2>
                            <form method="post" action="<?php echo e(route('contact')); ?>" class="verify-gcaptcha">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-xl-6 col-lg-12 col-sm-6 form-group">
                                        <label for="name" class="form--label label-two"><?php echo app('translator')->get('Your Name'); ?></label>
                                        <input type="text" name="name" class="form--control" id="name"
                                            value="<?php echo e(old('name', @$user->fullname)); ?>"
                                            <?php if($user && $user->profile_complete): ?> readonly <?php endif; ?> required>
                                    </div>
                                    <div class="col-xl-6 col-lg-12 col-sm-6 form-group">
                                        <label for="email" class="form--label  label-two"> <?php echo app('translator')->get('Email'); ?> </label>
                                        <input type="email" name="email" class="form--control" id="email"
                                            value="<?php echo e(old('email', @$user->email)); ?>"
                                            <?php if($user): ?> readonly <?php endif; ?> required>
                                    </div>
                                    <div class="col-sm-12 form-group">
                                        <label for="sub" class="form--label  label-two"> <?php echo app('translator')->get('Subject'); ?> </label>
                                        <input type="text" name="subject" class="form--control" id="sub"
                                            value="<?php echo e(old('subject')); ?>" required>
                                    </div>
                                    <div class="col-sm-12 form-group">
                                        <label for="mes" class="form--label  label-two"> <?php echo app('translator')->get('Message'); ?> </label>
                                        <textarea class="form--control" name="message" id="mes" cols="30" rows="10" required><?php echo e(old('message')); ?></textarea>
                                    </div>
                                    <div class="col-sm-12">
                                        <?php if (isset($component)) { $__componentOriginalff0a9fdc5428085522b49c68070c11d6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalff0a9fdc5428085522b49c68070c11d6 = $attributes; } ?>
<?php $component = App\View\Components\Captcha::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('captcha'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Captcha::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $attributes = $__attributesOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $component = $__componentOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__componentOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
                                    </div>
                                    <div class="col-12">
                                        <button type="submit" class="btn btn--base w-100"><?php echo app('translator')->get('Submit'); ?> <span
                                                class="icon"></span></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <?php if(@$sections->secs != null): ?>
        <?php $__currentLoopData = json_decode($sections); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo $__env->make($activeTemplate . 'sections.' . $sec, array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/cryptowonder/domains/trade.cryptowonder.xyz/public_html/core/resources/views/templates/basic/contact.blade.php ENDPATH**/ ?>