<?php
    $commodities = App\Models\Commodity::active()->hasPrice()->orderBy('name')->take(15)->get();
    $commodityContent = getContent('commodity.content', true);
?>

<section class="testimonials py-110 section-bg">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-7">
                <div class="section-heading">
                    <h2 class="section-heading__title" data-s-break="1"><?php echo e(__(@$commodityContent->data_values->heading)); ?>

                    </h2>
                    <p class="section-heading__desc"> <?php echo e(__(@$commodityContent->data_values->subheading)); ?></p>
                </div>
            </div>
            <div class="cl-12">
                <?php echo $__env->make($activeTemplate . 'partials.commodity_table', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </div>
        </div>
    </div>
</section>
<?php /**PATH /home/cryptowonder/domains/trade.cryptowonder.xyz/public_html/core/resources/views/templates/basic/sections/commodity.blade.php ENDPATH**/ ?>