<?php if(!$commodities->isEmpty()): ?>
    <div class="trade-table">
        <table class="table table--responsive--xxl">
            <thead>
                <tr>
                    <th> <?php echo app('translator')->get('Commodities'); ?> </th>
                    <th> <?php echo app('translator')->get('Current Price'); ?></th>
                    <th><?php echo app('translator')->get('Unit'); ?></th>
                    <th> <?php echo app('translator')->get('24h'); ?>% </th>
                    <th> <?php echo app('translator')->get('7d'); ?>% </th>
                    <th> <?php echo app('translator')->get('Market Capital'); ?></th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $commodities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $commodity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <div class="commodities flex-align">
                                <div class="commodities__thumb">
                                    <img src="<?php echo e(getImage(getFilePath('commodityImage') . '/' . $commodity->image, getFileSize('commodityImage'))); ?>"
                                        class="fit-image" alt="<?php echo app('translator')->get('Commodity Image'); ?>">
                                </div>
                                <div class="commodities__content">
                                    <h6 class="commodities__name"><?php echo e(__($commodity->name)); ?></h6>
                                </div>
                            </div>
                        </td>
                        <td>
                            <div><?php echo e(showAmount($commodity->price)); ?></div>
                        </td>
                        <td>
                            <?php echo e(__($commodity->unit)); ?>

                        </td>
                        <td>
                            <div>
                                <?php echo e(__($commodity->twenty_four_hour_change)); ?>%
                                <span
                                    class="<?php echo e($commodity->twenty_four_hour_change < 0 ? 'text--danger' : 'text--success'); ?>">
                                    <i
                                        class="fa-solid <?php echo e($commodity->twenty_four_hour_change < 0 ? 'fa-arrow-trend-down' : 'fa-arrow-trend-up'); ?>"></i>
                                </span>
                            </div>
                        </td>
                        <td>
                            <div> <?php echo e(__($commodity->seven_day_change)); ?>%
                                <span class="<?php echo e($commodity->seven_day_change < 0 ? 'text--danger' : 'text--success'); ?>">
                                    <i
                                        class="fa-solid <?php echo e($commodity->seven_day_change < 0 ? 'fa-arrow-trend-down' : 'fa-arrow-trend-up'); ?>"></i>
                                </span>
                            </div>
                        </td>
                        <td><?php echo e($commodity->market_capital == 0 ? '-----' : showAmount($commodity->market_capital)); ?>

                        </td>
                        <td>
                            <a href="<?php echo e(route('user.trade.index')); ?>?commodity_id=<?php echo e($commodity->id); ?>"
                                class="btn btn--base btn--sm">
                                <i class="fa-solid fa-arrow-trend-up"></i> <?php echo app('translator')->get('TRADE NOW'); ?>
                            </a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
<?php else: ?>
    <?php echo $__env->make($activeTemplate . 'partials.empty', ['data' => 'No commodity found'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php endif; ?>
<?php /**PATH /home/cryptowonder/domains/trade.cryptowonder.xyz/public_html/core/resources/views/templates/basic/partials/commodity_table.blade.php ENDPATH**/ ?>